/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.misc.FrequencyOrderedCollection;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.smarterfarmers.FarmTaskDebugRenderer;
import net.mehvahdjukaar.smarterfarmers.FarmTaskLogic;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.mehvahdjukaar.smarterfarmers.integration.QuarkIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SFHarvestFarmland
extends HarvestFarmland {
    public int plantTimer;
    public BlockPos aboveFarmlandPos = null;
    public ItemStack seedToHold = null;
    @VisibleForTesting
    public boolean active = false;
    @VisibleForTesting
    public List<Pair<BlockPos, Action>> farmlandAround;
    @VisibleForTesting
    public long lastTriedToStart;

    protected boolean checkExtraStartConditions(ServerLevel level, Villager owner) {
        this.lastTriedToStart = level.getGameTime();
        if (!level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (owner.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        this.farmlandAround = this.getValidFarmlandAround(level, owner);
        if (this.farmlandAround.isEmpty()) {
            return false;
        }
        Pair<BlockPos, Action> chosen = this.farmlandAround.get(level.getRandom().nextInt(this.farmlandAround.size()));
        this.aboveFarmlandPos = (BlockPos)chosen.getFirst();
        this.seedToHold = null;
        if (chosen.getSecond() == Action.PLANT) {
            ItemStack seed = this.getSeedToPlantAt(this.aboveFarmlandPos, level, owner);
            if (!seed.isEmpty()) {
                this.seedToHold = seed;
            } else {
                this.farmlandAround.removeIf(e -> e.getSecond() == Action.PLANT);
                if (this.farmlandAround.isEmpty()) {
                    return false;
                }
                chosen = this.farmlandAround.get(level.getRandom().nextInt(this.farmlandAround.size()));
                this.aboveFarmlandPos = (BlockPos)chosen.getFirst();
            }
        }
        return true;
    }

    private List<Pair<BlockPos, Action>> getValidFarmlandAround(ServerLevel level, Villager owner) {
        ArrayList<Pair<BlockPos, Action>> validFarmland = new ArrayList<Pair<BlockPos, Action>>();
        BlockPos.MutableBlockPos mutableBlockPos = owner.blockPosition().mutable();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    mutableBlockPos.set(owner.getX() + (double)i, owner.getY() + (double)j, owner.getZ() + (double)k);
                    Action actionForPos = this.getActionForPos((BlockPos)mutableBlockPos, level);
                    if (actionForPos == null) continue;
                    validFarmland.add((Pair<BlockPos, Action>)Pair.of((Object)new BlockPos((Vec3i)mutableBlockPos), (Object)((Object)actionForPos)));
                }
            }
        }
        return validFarmland;
    }

    protected ItemStack getSeedToPlantAt(BlockPos targetPos, ServerLevel level, Villager villager) {
        FrequencyOrderedCollection blockAsItemAround = new FrequencyOrderedCollection();
        BlockPos.MutableBlockPos mutableBlockPos = targetPos.mutable();
        boolean hasAirInNeighbor = false;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Item item;
                    if (x == 0 && z == 0) continue;
                    mutableBlockPos.set(targetPos.getX() + x, targetPos.getY() + y, targetPos.getZ() + z);
                    BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
                    if (!hasAirInNeighbor && y == 0 && Math.abs(x) + Math.abs(z) == 1) {
                        hasAirInNeighbor = blockState.isAir();
                    }
                    if ((item = blockState.getBlock().asItem()) == Items.AIR) continue;
                    blockAsItemAround.add((Object)item);
                }
            }
        }
        SimpleContainer inventory = villager.getInventory();
        HashSet<Item> availableSeeds = new HashSet<Item>();
        HashMap<Item, ItemStack> villagerSeedsInInventory = new HashMap<Item, ItemStack>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            Item it = itemStack.getItem();
            if (itemStack.isEmpty() || !SFPlatformStuff.isValidSeed(itemStack, villager)) continue;
            availableSeeds.add(it);
            villagerSeedsInInventory.put(it, itemStack);
        }
        if (availableSeeds.isEmpty()) {
            return ItemStack.EMPTY;
        }
        boolean failedForMelon = false;
        for (Item item : blockAsItemAround) {
            if (!availableSeeds.contains(item)) continue;
            if (item.getDefaultInstance().is(SmarterFarmers.STEM_SEEDS) && (targetPos.getX() + targetPos.getZ()) % 2 == 0) {
                failedForMelon = true;
                continue;
            }
            return (ItemStack)villagerSeedsInInventory.get(item);
        }
        if (failedForMelon) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)villagerSeedsInInventory.get(availableSeeds.iterator().next());
    }

    protected void start(ServerLevel level, Villager entity, long gameTime) {
        this.active = true;
        this.plantTimer = SmarterFarmers.TIME_TO_HARVEST.get();
        Preconditions.checkNotNull((Object)this.aboveFarmlandPos);
        entity.setItemSlot(EquipmentSlot.MAINHAND, this.seedToHold != null ? this.seedToHold.copy() : FarmTaskLogic.getHoe(entity));
        entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.aboveFarmlandPos));
        entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
        if (PlatHelper.getPhysicalSide() == PlatHelper.Side.CLIENT) {
            FarmTaskDebugRenderer.INSTANCE.trackTask(entity, this);
        }
    }

    protected void stop(ServerLevel level, Villager entity, long gameTime) {
        this.active = false;
        entity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        entity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.aboveFarmlandPos = null;
        this.farmlandAround.clear();
    }

    @Nullable
    protected Action getActionForPos(BlockPos pos, ServerLevel level) {
        BlockState cropState = level.getBlockState(pos);
        BlockState farmState = level.getBlockState(pos.below());
        boolean validFarmland = FarmTaskLogic.isValidFarmland(farmState.getBlock());
        if (validFarmland) {
            if (FarmTaskLogic.isCropMature(cropState, pos, (Level)level)) {
                return Action.HARVEST_AND_REPLANT;
            }
            if (cropState.isAir()) {
                return Action.plantIfNoMelonsAround(pos, level);
            }
        }
        if (cropState.is(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT) && farmState.is(SmarterFarmers.FARMER_TILLABLE)) {
            return Action.HARVEST;
        }
        if (cropState.is(SmarterFarmers.HARVESTABLE_ON_DIRT) && farmState.is(SmarterFarmers.FARMER_TILLABLE)) {
            return Action.HARVEST_AND_REPLANT;
        }
        if (cropState.isAir() && SmarterFarmers.PLANT_ON_DIRT.get().booleanValue() && farmState.is(SmarterFarmers.FARMER_TILLABLE)) {
            return Action.plantIfNoMelonsAround(pos, level);
        }
        return null;
    }

    public void tick(ServerLevel level, Villager villager, long tickCount) {
        if (!this.aboveFarmlandPos.closerToCenterThan((Position)villager.position(), 2.0)) {
            return;
        }
        --this.plantTimer;
        if (this.plantTimer > 0) {
            return;
        }
        BlockState targetState = level.getBlockState(this.aboveFarmlandPos);
        BlockPos belowPos = this.aboveFarmlandPos.below();
        Item toReplace = Items.AIR;
        if (!targetState.isAir()) {
            if (targetState.is(SmarterFarmers.SPECIAL_HARVESTABLE) || targetState.is(SmarterFarmers.HARVESTABLE_ON_DIRT) || targetState.is(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT)) {
                level.destroyBlock(this.aboveFarmlandPos, true, (Entity)villager);
                BlockState below = level.getBlockState(belowPos);
                if (SFPlatformStuff.tillBlock(below, belowPos, level)) {
                    level.playSound(null, belowPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (targetState.is(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
            } else if (FarmTaskLogic.isCropMature(targetState, this.aboveFarmlandPos, (Level)level)) {
                if (SmarterFarmers.QUARK && QuarkIntegration.breakWithAutoReplant(level, this.aboveFarmlandPos, (LivingEntity)villager)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
                toReplace = targetState.getBlock().asItem();
                level.destroyBlock(this.aboveFarmlandPos, true, (Entity)villager);
            }
        }
        BlockState farmlandBlock = level.getBlockState(belowPos);
        targetState = level.getBlockState(this.aboveFarmlandPos);
        if (targetState.isAir()) {
            if (FarmTaskLogic.isValidFarmland(farmlandBlock.getBlock())) {
                this.replant(level, villager, toReplace);
            } else if (farmlandBlock.is(SmarterFarmers.FARMER_TILLABLE) && SFPlatformStuff.tillBlock(farmlandBlock, belowPos, level)) {
                level.playSound(null, belowPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.replant(level, villager, toReplace);
            }
        }
        this.aboveFarmlandPos = null;
    }

    private void replant(ServerLevel level, Villager villager, Item toReplace) {
        ItemStack itemToPlant = ItemStack.EMPTY;
        if (toReplace != Items.AIR) {
            itemToPlant = this.findSameItem(villager.getInventory(), toReplace);
        }
        if (itemToPlant.isEmpty()) {
            itemToPlant = this.getSeedToPlantAt(this.aboveFarmlandPos, level, villager);
        }
        if (!itemToPlant.isEmpty()) {
            boolean success = false;
            if (SFPlatformStuff.trySpecialPlant(level, this.aboveFarmlandPos, itemToPlant, villager)) {
                success = true;
            } else {
                Item item = itemToPlant.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState toPlant = blockItem.getBlock().defaultBlockState();
                    level.setBlock(this.aboveFarmlandPos, toPlant, 3);
                    success = true;
                }
            }
            if (success) {
                BlockState placed = level.getBlockState(this.aboveFarmlandPos);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, this.aboveFarmlandPos, GameEvent.Context.of((Entity)villager, (BlockState)placed));
                level.playSound(null, (double)this.aboveFarmlandPos.getX(), (double)this.aboveFarmlandPos.getY(), (double)this.aboveFarmlandPos.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                itemToPlant.shrink(1);
            } else {
                SmarterFarmers.LOGGER.error("Failed to replant {} from item {}", (Object)toReplace, (Object)itemToPlant);
            }
        } else {
            SmarterFarmers.LOGGER.error("Failed to replant {}", (Object)toReplace);
        }
    }

    @NotNull
    private ItemStack findSameItem(SimpleContainer inventory, Item toReplace) {
        if (toReplace != Items.AIR && toReplace instanceof BlockItem) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack is = inventory.getItem(i);
                if (is.getItem() != toReplace) continue;
                return is;
            }
        }
        return ItemStack.EMPTY;
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return this.aboveFarmlandPos != null;
    }

    public static enum Action {
        HARVEST,
        HARVEST_AND_REPLANT,
        PLANT;


        @Nullable
        public static Action plantIfNoMelonsAround(BlockPos pos, ServerLevel level) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.relative(dir);
                BlockState neighborState = level.getBlockState(neighbor);
                if (!(neighborState.getBlock() instanceof StemBlock)) continue;
                boolean hasOtherSpace = false;
                for (Direction dir2 : Direction.Plane.HORIZONTAL) {
                    BlockPos neighbor2;
                    if (dir2 == dir.getOpposite() || !level.getBlockState(neighbor2 = neighbor.relative(dir2)).isAir()) continue;
                    hasOtherSpace = true;
                    break;
                }
                if (hasOtherSpace) continue;
                return null;
            }
            return PLANT;
        }

        public boolean harvests() {
            return this == HARVEST || this == HARVEST_AND_REPLANT;
        }
    }
}

