/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createcclogistics.peripheral;

import com.xeli.createcclogistics.peripheral.IPeripheralWithInventory;
import com.xeli.createcclogistics.peripheral.container.ForgeContainerTransfer;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u001e\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00130\u0013H\u0017J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0011H\u0017J<\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0017J<\u0010!\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0017J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0014H\u0002J0\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/xeli/createcclogistics/peripheral/InventoryPeripheral;", "Lcom/xeli/createcclogistics/peripheral/IPeripheralWithInventory;", "inventory", "Lnet/neoforged/neoforge/items/IItemHandler;", "be", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "<init>", "(Lnet/neoforged/neoforge/items/IItemHandler;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/core/Direction;)V", "getInventory", "()Lnet/neoforged/neoforge/items/IItemHandler;", "getBe", "()Lnet/minecraft/world/level/block/entity/BlockEntity;", "getDirection", "()Lnet/minecraft/core/Direction;", "size", "", "list", "", "", "getItemDetail", "slot", "getItemLimit", "", "pushItems", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "toName", "fromSlot", "limit", "Ljava/util/Optional;", "toSlot", "pullItems", "fromName", "assertBetween", "", "value", "min", "max", "message", "moveItem", "from", "to", "extractHandler", "peripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "createcclogistics-1.21.1"})
public final class InventoryPeripheral
implements IPeripheralWithInventory {
    @NotNull
    private final IItemHandler inventory;
    @NotNull
    private final BlockEntity be;
    @NotNull
    private final Direction direction;

    public InventoryPeripheral(@NotNull IItemHandler inventory, @NotNull BlockEntity be, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.inventory = inventory;
        this.be = be;
        this.direction = direction;
    }

    @NotNull
    public final IItemHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final BlockEntity getBe() {
        return this.be;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @Override
    @LuaFunction(mainThread=true)
    public int size() {
        return this.inventory.getSlots();
    }

    @Override
    @LuaFunction(mainThread=true)
    @NotNull
    public Map<Integer, Map<String, ?>> list() {
        Map result = new HashMap();
        int size = this.inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return result;
    }

    @Override
    @LuaFunction(mainThread=true)
    @Nullable
    public Map<String, ?> getItemDetail(int slot) {
        this.assertBetween(slot, 1, this.inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = this.inventory.getStackInSlot(slot - 1);
        return stack.isEmpty() ? null : VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack);
    }

    @Override
    @LuaFunction(mainThread=true)
    public long getItemLimit(int slot) {
        this.assertBetween(slot, 1, this.inventory.getSlots(), "Slot out of range (%s)");
        return this.inventory.getSlotLimit(slot - 1);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pushItems(@NotNull IComputerAccess computer, @NotNull String toName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        IItemHandler iItemHandler = this.extractHandler(location);
        if (iItemHandler == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        IItemHandler to = iItemHandler;
        Integer actualLimit = limit.orElse(Integer.MAX_VALUE);
        this.assertBetween(fromSlot, 1, this.inventory.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            Integer n = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            this.assertBetween(((Number)n).intValue(), 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        int n = ((Number)toSlot.orElse(0)).intValue() - 1;
        Intrinsics.checkNotNull((Object)actualLimit);
        return this.moveItem(this.inventory, fromSlot - 1, to, n, actualLimit);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pullItems(@NotNull IComputerAccess computer, @NotNull String fromName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void assertBetween(int value, int min, int max, String message) {
        if (value < min || value > max) {
            Object[] objectArray = new Object[]{"between " + min + " and " + max};
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new LuaException(string);
        }
    }

    private final int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ForgeContainerTransfer fromWrapper = new ForgeContainerTransfer(from, 0, 0, 0, 14, null).singleSlot(fromSlot);
        ForgeContainerTransfer toWrapper = new ForgeContainerTransfer(to, 0, 0, 0, 14, null);
        if (toSlot >= 0) {
            toWrapper = toWrapper.singleSlot(toSlot);
        }
        return (int)Math.max(0.0, (double)fromWrapper.moveTo(toWrapper, limit));
    }

    private final IItemHandler extractHandler(IPeripheral peripheral) {
        throw new NotImplementedError(null, 1, null);
    }
}

