/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class QuadrocopterEntity
extends Rotorcraft {
    public QuadrocopterEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
        this.adaptPlayerRotation = false;
    }

    @Override
    protected float getInputInterpolationSteps() {
        return 5.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_TINY.get();
    }

    @Override
    public Item asItem() {
        return Items.QUADROCOPTER.get();
    }

    @Override
    protected double getDefaultGravity() {
        return this.wasTouchingWater ? (double)-0.04f : (double)(1.0f - this.getEnginePower()) * super.getDefaultGravity();
    }

    @Override
    protected void updateController() {
        if (this.canTurnOnEngine((Entity)this.getControllingPassenger())) {
            this.setEngineTarget(1.0f);
        }
        if (!this.onGround()) {
            this.setXRot(this.getXRot() + this.getProperties().get(VehicleStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.setXRot(this.getXRot() * (1.0f - this.getProperties().getAdditive(VehicleStat.STABILIZER)));
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        LivingEntity pilot = this.getControllingPassenger();
        if (pilot != null) {
            float diff = pilot.getYHeadRot() - this.getYRot();
            if (diff > 180.0f) {
                diff -= 360.0f;
            } else if (diff < -180.0f) {
                diff += 360.0f;
            }
            diff *= this.getProperties().get(VehicleStat.YAW_SPEED);
            if (Math.abs(diff) < 60.0f) {
                this.setYRot(this.getYRot() + diff);
            }
        }
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED));
        Vector3f direction = this.getRightDirection().mul(thrust * this.pressingInterpolatedX.getSmooth());
        this.setDeltaMovement(this.getDeltaMovement().add((double)direction.x, (double)direction.y, (double)direction.z));
        direction = this.getForwardDirection().mul(thrust * this.pressingInterpolatedZ.getSmooth());
        this.setDeltaMovement(this.getDeltaMovement().add((double)direction.x, (double)direction.y, (double)direction.z));
    }

    @Override
    protected void convertPower(Vec3 direction) {
    }
}

