/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_aircraft.Main;
import immersive_aircraft.WeaponRendererRegistry;
import immersive_aircraft.client.render.entity.renderer.DyeableVehicleEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.BBModelRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.client.render.entity.weaponRenderer.WeaponRenderer;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public abstract class InventoryVehicleRenderer<T extends InventoryVehicleEntity>
extends DyeableVehicleEntityRenderer<T> {
    public InventoryVehicleRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderLocal(T entity, float yaw, float tickDelta, PoseStack matrixStack, PoseStack.Pose peek, MultiBufferSource vertexConsumerProvider, int light) {
        super.renderLocal(entity, yaw, tickDelta, matrixStack, peek, vertexConsumerProvider, light);
        LocalPlayer player = Minecraft.getInstance().player;
        for (List<Weapon> weapons : ((InventoryVehicleEntity)((Object)entity)).getWeapons().values()) {
            for (Weapon weapon : weapons) {
                WeaponRenderer<Weapon> renderer;
                if (weapon.getMount().blocking() && Main.firstPersonGetter.isFirstPerson() && player != null && entity.hasPassenger((Entity)player) || (renderer = WeaponRendererRegistry.get(weapon)) == null) continue;
                renderer.render(entity, weapon, matrixStack, vertexConsumerProvider, light, tickDelta);
            }
        }
    }

    public void renderBanners(BBModel model, BBObject ignoredObject, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float ignoredTime, ModelPartRenderHandler<T> ignoredModelPartRenderer) {
        List<ItemStack> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            BBObject bannerObject;
            Item item;
            if (slot.isEmpty() || !((item = slot.getItem()) instanceof BannerItem)) continue;
            BannerItem bannerItem = (BannerItem)item;
            DyeColor baseColor = bannerItem.getColor();
            BannerPatternLayers banner = (BannerPatternLayers)slot.get(DataComponents.BANNER_PATTERNS);
            if (banner == null || !((bannerObject = model.objectsByName.get("banner_" + i++)) instanceof BBFaceContainer)) continue;
            BBFaceContainer bannerContainer = (BBFaceContainer)((Object)bannerObject);
            BBModelRenderer.renderBanner(bannerContainer, matrixStack, vertexConsumerProvider, light, true, baseColor, banner.layers());
        }
    }

    public void renderSails(BBObject object, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float time) {
        DyeColor color;
        List<ItemStack> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.DYE);
        ItemStack stack = slots.stream().findFirst().orElse(ItemStack.EMPTY);
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            color = item2.getDyeColor();
        } else {
            color = DyeColor.WHITE;
        }
        int c = color.getTextureDiffuseColor();
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        if (object instanceof BBMesh) {
            BBMesh mesh = (BBMesh)object;
            BBModelRenderer.renderSailObject(mesh, matrixStack, vertexConsumerProvider, light, time, r, g, b, 1.0f);
        }
    }
}

