/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.platform.InputConstants;
import immersive_aircraft.mixin.client.KeyMappingAccessorMixin;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class MultiKeyMapping
extends KeyMapping {
    public final InputConstants.Key customDefaultKey;
    public InputConstants.Key customBoundKey;
    public static final Map<InputConstants.Key, List<MultiKeyMapping>> KEY_TO_BINDING = new HashMap<InputConstants.Key, List<MultiKeyMapping>>();

    public MultiKeyMapping(String translationKey, InputConstants.Type type, int code, String category) {
        super(translationKey, type, -1, category);
        InputConstants.Key key;
        this.customDefaultKey = this.customBoundKey = (key = type.getOrCreate(code));
        KEY_TO_BINDING.computeIfAbsent(this.customBoundKey, v -> new LinkedList()).add(this);
    }

    public boolean isDown() {
        this.validate();
        return super.isDown();
    }

    public String saveString() {
        return this.customBoundKey.getName();
    }

    public Component getTranslatedKeyMessage() {
        return this.customBoundKey.getDisplayName();
    }

    public InputConstants.Key getDefaultKey() {
        return this.customDefaultKey;
    }

    public void setKey(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull InputConstants.Key boundKey) {
        this.customBoundKey = boundKey;
    }

    public boolean isUnbound() {
        return this.customBoundKey.equals((Object)InputConstants.UNKNOWN);
    }

    public boolean isDefault() {
        return this.customBoundKey.equals((Object)this.customDefaultKey);
    }

    public void validate() {
        if (!super.isDefault()) {
            this.customBoundKey = ((KeyMappingAccessorMixin)((Object)this)).getKey();
            super.setKey(super.getDefaultKey());
            MultiKeyMapping.resetMapping();
        }
    }
}

