/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.neoforge.cobalt.network;

import immersive_armors.cobalt.network.Message;
import immersive_armors.cobalt.network.NetworkHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandlerImpl
extends NetworkHandler.Impl {
    Map<String, List<MessageRegistryEntry>> messageRegistry = new HashMap<String, List<MessageRegistryEntry>>();

    @Override
    public <T extends Message> void registerMessage(String namespace, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec, NetworkHandler.ClientHandler<T> clientHandler, NetworkHandler.ServerHandler<T> serverHandler) {
        this.messageRegistry.computeIfAbsent(namespace, k -> new LinkedList());
        DirectionalPayloadHandler payloadHandler = new DirectionalPayloadHandler((m, c) -> clientHandler.handle(m), (m, c) -> serverHandler.handle(m, (ServerPlayer)c.player()));
        this.messageRegistry.get(namespace).add(new MessageRegistryEntry(type, codec, payloadHandler));
    }

    @Override
    public void sendToServer(Message m) {
        PacketDistributor.sendToServer((CustomPacketPayload)m, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayer(Message m, ServerPlayer e) {
        PacketDistributor.sendToPlayer((ServerPlayer)e, (CustomPacketPayload)m, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToTrackingPlayers(Message m, Entity origin) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)origin, (CustomPacketPayload)m, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        this.messageRegistry.values().forEach(channel -> channel.forEach(entry -> registrar.playBidirectional(entry.type, entry.codec, (IPayloadHandler)entry.payloadHandler)));
    }

    record MessageRegistryEntry(CustomPacketPayload.Type type, StreamCodec codec, DirectionalPayloadHandler payloadHandler) {
    }
}

