/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.neoforge;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import immersive_armors.Items;
import immersive_armors.config.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class LootProvider {
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"immersive_armors");
    private static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<ImmersiveArmorsLootModifier>> ARMOR_MODIFIER_SERIALIZER = GLM.register("armor_modifier_serializer", ImmersiveArmorsLootModifier.CODEC);

    public static void initialize(IEventBus bus) {
        if (Config.getInstance().lootChance > 0.0f) {
            GLM.register(bus);
        }
    }

    private static class ImmersiveArmorsLootModifier
    extends LootModifier {
        public static final Supplier<MapCodec<ImmersiveArmorsLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ImmersiveArmorsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ImmersiveArmorsLootModifier::new)));

        public ImmersiveArmorsLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ResourceLocation id = context.getQueriedLootTableId();
            if (Items.lootLookup.containsKey(id.toString())) {
                for (Map.Entry<Supplier<Item>, Float> entry : Items.lootLookup.get(id.toString()).entrySet()) {
                    if (!(context.getLevel().getRandom().nextFloat() < entry.getValue().floatValue() * Config.getInstance().lootChance)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)entry.getKey().get()));
                }
            }
            return generatedLoot;
        }

        @NotNull
        public MapCodec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class DataProvider
    extends GlobalLootModifierProvider {
        public DataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String id) {
            super(output, registries, id);
        }

        protected void start() {
            for (String s : Items.lootLookup.keySet()) {
                this.add("armor_modifier_serializer_" + s, (IGlobalLootModifier)new ImmersiveArmorsLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)s)).build()}), new ICondition[0]);
            }
        }
    }

    @EventBusSubscriber(modid="immersive_armors", bus=EventBusSubscriber.Bus.MOD)
    public static class EventHandlers {
        @SubscribeEvent
        public static void runData(GatherDataEvent event) {
            if (Config.getInstance().lootChance > 0.0f) {
                event.getGenerator().addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new DataProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), "immersive_armors"));
            }
        }
    }
}

