/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import immersive_armors.Items;
import immersive_armors.config.Config;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobMixin {
    @Unique
    private static final Random immersiveArmors$equipmentRandom = new Random();

    @Inject(method={"getEquipmentForSlot(Lnet/minecraft/world/entity/EquipmentSlot;I)Lnet/minecraft/world/item/Item;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void immersiveArmors$injectGetEquipmentForSlot(EquipmentSlot equipmentSlot, int equipmentLevel, CallbackInfoReturnable<Item> cir) {
        HashMap<Integer, ExtendedArmorMaterial> items = new HashMap<Integer, ExtendedArmorMaterial>(){
            {
                this.put(0, Items.WOODEN_ARMOR);
                this.put(1, Items.WARRIOR_ARMOR);
                this.put(2, Items.HEAVY_ARMOR);
                this.put(3, Items.DIVINE_ARMOR);
                this.put(4, Items.PRISMARINE_ARMOR);
            }
        };
        if (items.containsKey(equipmentLevel) && immersiveArmors$equipmentRandom.nextFloat() < Config.getInstance().mobEntityUseImmersiveArmorChance) {
            Supplier<Item> item;
            String name = ((ExtendedArmorMaterial)items.get(equipmentLevel)).getName();
            switch (equipmentSlot) {
                case HEAD: {
                    Supplier<Item> supplier = Items.items.get(name + "_helmet");
                    break;
                }
                case CHEST: {
                    Supplier<Item> supplier = Items.items.get(name + "_chestplate");
                    break;
                }
                case LEGS: {
                    Supplier<Item> supplier = Items.items.get(name + "_leggings");
                    break;
                }
                case FEET: {
                    Supplier<Item> supplier = Items.items.get(name + "_boots");
                    break;
                }
                default: {
                    Supplier<Item> supplier = item = null;
                }
            }
            if (item != null) {
                cir.setReturnValue((Object)item.get());
            }
        }
    }
}

