/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import immersive_armors.Main;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.client.render.entity.piece.Piece;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public class ExtendedArmorMaterial {
    private final String name;
    private int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protection = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 0);
        map.put(ArmorItem.Type.LEGGINGS, 0);
        map.put(ArmorItem.Type.CHESTPLATE, 0);
        map.put(ArmorItem.Type.HELMET, 0);
        map.put(ArmorItem.Type.BODY, 0);
    });
    private final boolean[] hidesSecondLayer = new boolean[]{false, false, false, false};
    private float toughness;
    private float knockbackResistance;
    private int enchantability;
    private float weight;
    private int color = 10511680;
    private float waterMovement;
    private final List<ArmorEffect> effects = new LinkedList<ArmorEffect>();
    private final Map<String, Float> loot = new HashMap<String, Float>();
    private boolean antiSkeleton;
    private final Map<EquipmentSlot, List<Piece>> pieces = new HashMap<EquipmentSlot, List<Piece>>();
    private boolean hideCape;
    private Holder<SoundEvent> equipSound;
    private Supplier<Ingredient> repairIngredient;
    private Holder<ArmorMaterial> registryReference;

    public ExtendedArmorMaterial(String name) {
        this.pieces.put(EquipmentSlot.HEAD, new LinkedList());
        this.pieces.put(EquipmentSlot.CHEST, new LinkedList());
        this.pieces.put(EquipmentSlot.LEGS, new LinkedList());
        this.pieces.put(EquipmentSlot.FEET, new LinkedList());
        this.name = name;
        this.protectionAmount(0, 0, 0, 0);
    }

    public ExtendedArmorMaterial durabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ExtendedArmorMaterial protectionAmount(int helmet, int chestplate, int legging, int boots) {
        this.protection.put(ArmorItem.Type.HELMET, helmet);
        this.protection.put(ArmorItem.Type.CHESTPLATE, chestplate);
        this.protection.put(ArmorItem.Type.LEGGINGS, legging);
        this.protection.put(ArmorItem.Type.BOOTS, boots);
        this.protection.put(ArmorItem.Type.BODY, chestplate);
        return this;
    }

    public ExtendedArmorMaterial toughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ExtendedArmorMaterial enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ExtendedArmorMaterial equipSound(SoundEvent equipSound) {
        return this.equipSound((Holder<SoundEvent>)Holder.direct((Object)equipSound));
    }

    public ExtendedArmorMaterial equipSound(Holder<SoundEvent> equipSound) {
        this.equipSound = equipSound;
        return this;
    }

    public ExtendedArmorMaterial repairIngredient(Supplier<Ingredient> repairIngredient) {
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ExtendedArmorMaterial knockbackReduction(float knockbackReduction) {
        this.knockbackResistance = knockbackReduction;
        return this;
    }

    public ExtendedArmorMaterial weight(float weight) {
        this.weight = weight;
        return this;
    }

    public ExtendedArmorMaterial color(int color) {
        this.color = color;
        return this;
    }

    public ExtendedArmorMaterial waterMovement(float waterMovement) {
        this.waterMovement = waterMovement;
        return this;
    }

    public ExtendedArmorMaterial effect(ArmorEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ExtendedArmorMaterial antiSkeleton() {
        this.antiSkeleton = true;
        return this;
    }

    public ExtendedArmorMaterial hideCape() {
        this.hideCape = true;
        return this;
    }

    public ExtendedArmorMaterial head(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlot.HEAD).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial chest(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlot.CHEST).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial legs(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlot.LEGS).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial feet(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlot.FEET).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial upper(Piece pieceSupplier) {
        this.head(pieceSupplier);
        this.chest(pieceSupplier);
        this.feet(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial lower(Piece pieceSupplier) {
        this.legs(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial full(Piece pieceSupplier) {
        this.upper(pieceSupplier);
        this.lower(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial addLoot(String name, float chance) {
        this.loot.put(name, Float.valueOf(chance));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getProtection(ArmorItem.Type slot) {
        return this.protection.get(slot);
    }

    public float getToughness() {
        return this.toughness;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public Holder<SoundEvent> getEquipSound() {
        return this.equipSound;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getColor() {
        return this.color;
    }

    public float getWaterMovement() {
        return this.waterMovement;
    }

    public List<ArmorEffect> getEffects() {
        if (Main.sharedConfig.enableEffects) {
            return this.effects;
        }
        return Collections.emptyList();
    }

    public boolean shouldHideCape() {
        return this.hideCape;
    }

    public List<Piece> getPieces(EquipmentSlot slot) {
        return this.pieces.get(slot);
    }

    public ExtendedArmorMaterial hidesSecondLayer(boolean head, boolean chest, boolean legs, boolean feet) {
        this.hidesSecondLayer[0] = head;
        this.hidesSecondLayer[1] = chest;
        this.hidesSecondLayer[2] = legs;
        this.hidesSecondLayer[3] = feet;
        return this;
    }

    public boolean[] shouldHideSecondLayer() {
        return this.hidesSecondLayer;
    }

    public boolean isAntiSkeleton() {
        return this.antiSkeleton;
    }

    public EnumMap<ArmorItem.Type, Integer> getProtection() {
        return this.protection;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public Map<String, Float> getLoot() {
        return this.loot;
    }

    public ArmorMaterial getMaterial() {
        return new ArmorMaterial(this.protection, this.enchantability, this.equipSound, this.repairIngredient, List.of(), this.toughness, this.knockbackResistance);
    }

    public void registerVanillaMaterial() {
        this.registryReference = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)Main.locate(this.getName()), (Object)this.getMaterial());
    }

    public Holder<ArmorMaterial> getRegistryReference() {
        return this.registryReference;
    }
}

