/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.cobalt.network;

import immersive_armors.cobalt.network.Message;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public abstract class NetworkHandler {
    private static Impl INSTANCE;

    public static <T extends Message> void handleDefault(T message, ServerPlayer e) {
        message.receiveServer(e);
    }

    public static <T extends Message> void handleDefault(T message) {
        message.receiveClient();
    }

    public static <T extends Message> void registerMessage(String namespace, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        NetworkHandler.registerMessage(namespace, type, codec, NetworkHandler::handleDefault, NetworkHandler::handleDefault);
    }

    public static <T extends Message> void registerMessage(String namespace, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec, ClientHandler<T> clientHandler, ServerHandler<T> serverHandler) {
        INSTANCE.registerMessage(namespace, type, codec, clientHandler, serverHandler);
    }

    public static void sendToServer(Message m) {
        INSTANCE.sendToServer(m);
    }

    public static void sendToPlayer(Message m, ServerPlayer e) {
        INSTANCE.sendToPlayer(m, e);
    }

    public static void sendToTrackingPlayers(Message m, Entity origin) {
        INSTANCE.sendToTrackingPlayers(m, origin);
    }

    public static interface ClientHandler<T extends Message> {
        public void handle(T var1);
    }

    public static interface ServerHandler<T extends Message> {
        public void handle(T var1, ServerPlayer var2);
    }

    public static abstract class Impl {
        protected Impl() {
            INSTANCE = this;
        }

        public abstract <T extends Message> void registerMessage(String var1, CustomPacketPayload.Type<T> var2, StreamCodec<RegistryFriendlyByteBuf, T> var3, ClientHandler<T> var4, ServerHandler<T> var5);

        public abstract void sendToServer(Message var1);

        public abstract void sendToPlayer(Message var1, ServerPlayer var2);

        public abstract void sendToTrackingPlayers(Message var1, Entity var2);
    }
}

