/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FireResistanceArmorEffect
extends ArmorEffect {
    private final float strength;

    public FireResistanceArmorEffect(float strength) {
        this.strength = strength;
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return amount * (1.0f - this.strength);
        }
        return amount;
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"armorEffect.fireResistance", (Object[])new Object[]{(int)(this.strength * 100.0f)}).withStyle(ChatFormatting.RED));
    }
}

