/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import immersive_armors.Items;
import immersive_armors.config.Config;
import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.ArmorItem;

public class ItemPropertyOverwrite {
    public static Map<String, Float> applyItemOverride(Map<String, Float> map) {
        HashMap<String, Float> backup = new HashMap<String, Float>();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            String[] split = entry.getKey().split(":");
            if (split.length == 2) {
                Optional<ExtendedArmorMaterial> found = Items.items.values().stream().map(Supplier::get).filter(ExtendedArmorItem.class::isInstance).map(i -> ((ExtendedArmorItem)((Object)i)).getExtendedMaterial()).filter(i -> i.getName().equals(split[0])).findAny();
                if (found.isPresent()) {
                    ExtendedArmorMaterial material = found.get();
                    EnumMap<ArmorItem.Type, Integer> protection = material.getProtection();
                    switch (split[1]) {
                        case "helmetProtection": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(protection.get(ArmorItem.Type.HELMET).floatValue()));
                            protection.put(ArmorItem.Type.HELMET, entry.getValue().intValue());
                            break;
                        }
                        case "chestplateProtection": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(protection.get(ArmorItem.Type.CHESTPLATE).floatValue()));
                            protection.put(ArmorItem.Type.CHESTPLATE, entry.getValue().intValue());
                            break;
                        }
                        case "leggingsProtection": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(protection.get(ArmorItem.Type.LEGGINGS).floatValue()));
                            protection.put(ArmorItem.Type.LEGGINGS, entry.getValue().intValue());
                            break;
                        }
                        case "bootsProtection": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(protection.get(ArmorItem.Type.BOOTS).floatValue()));
                            protection.put(ArmorItem.Type.BOOTS, entry.getValue().intValue());
                            break;
                        }
                        case "weight": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(material.getWeight()));
                            material.weight(entry.getValue().floatValue());
                            break;
                        }
                        case "toughness": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(material.getToughness()));
                            material.toughness(entry.getValue().floatValue());
                            break;
                        }
                        case "enchantability": {
                            backup.putIfAbsent(entry.getKey(), Float.valueOf(material.getEnchantability()));
                            material.enchantability(entry.getValue().intValue());
                            break;
                        }
                        default: {
                            Config.LOGGER.error("Armor property {} for item {} does not exist!", (Object)split[1], (Object)split[0]);
                        }
                    }
                    Items.items.values().stream().map(Supplier::get).filter(i -> i instanceof ExtendedArmorItem && ((ExtendedArmorItem)((Object)i)).getExtendedMaterial() == material).forEach(i -> ((ExtendedArmorItem)((Object)i)).refreshAttributes());
                    continue;
                }
                Config.LOGGER.error("Item {} for armor property overwrite does not exist!", (Object)split[0]);
                continue;
            }
            Config.LOGGER.error("Malformed armor property overwrite: {}", (Object)entry.getKey());
        }
        return backup;
    }
}

