/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.loader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_loader_core.mods.LoadedMods;

public class LoaderManager
implements LoaderManagerService {
    private Collection<FileInspection.Mod> modList = new ArrayList<FileInspection.Mod>();
    private int lastLoadingModListSize = -1;

    @Override
    public LoaderManagerService.ModPlatform getPlatformType() {
        return LoaderManagerService.ModPlatform.NEOFORGE;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    @Override
    public Collection<FileInspection.Mod> getModList() {
        if (GlobalVariables.preload.booleanValue()) {
            return this.modList;
        }
        List modInfo = FMLLoader.getLoadingModList().getMods();
        if (!this.modList.isEmpty() && this.lastLoadingModListSize == modInfo.size()) {
            return this.modList;
        }
        this.lastLoadingModListSize = modInfo.size();
        ArrayList<FileInspection.Mod> modList = new ArrayList<FileInspection.Mod>();
        for (ModInfo info : modInfo) {
            try {
                String hash;
                String modID = info.getModId();
                Path path = this.getModPath(modID);
                if (path == null || path.toString().isEmpty() || (hash = CustomFileUtils.getHash(path)) == null) continue;
                List<String> dependencies = info.getDependencies().stream().filter(d -> d.getType() == IModInfo.DependencyType.REQUIRED).map(IModInfo.ModVersion::getModId).toList();
                FileInspection.Mod mod = new FileInspection.Mod(modID, hash, List.of(), info.getOwningFile().versionString(), path, LoaderManagerService.EnvironmentType.UNIVERSAL, dependencies);
                modList.add(mod);
            }
            catch (Exception exception) {}
        }
        this.modList = modList;
        return this.modList;
    }

    @Override
    public String getLoaderVersion() {
        return FMLLoader.versionInfo().neoForgeVersion();
    }

    private Path getModPath(String modId) {
        if (this.isDevelopmentEnvironment()) {
            return null;
        }
        try {
            ModFileInfo modInfo;
            List mods;
            if (GlobalVariables.preload.booleanValue()) {
                List<ModFile> modFiles = LoadedMods.INSTANCE.candidateMods;
                for (ModFile modFile : modFiles) {
                    if (modFile.getModFileInfo() == null || modFile.getModInfos().isEmpty() || !((IModInfo)modFile.getModInfos().get(0)).getModId().equals(modId)) continue;
                    return ((IModInfo)modFile.getModInfos().get(0)).getOwningFile().getFile().getFilePath().toAbsolutePath();
                }
            } else if (this.isModLoaded(modId) && !(mods = (modInfo = FMLLoader.getLoadingModList().getModFileById(modId)).getMods()).isEmpty()) {
                return ((IModInfo)mods.get(0)).getOwningFile().getFile().getFilePath().toAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public LoaderManagerService.EnvironmentType getEnvironmentType() {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            return LoaderManagerService.EnvironmentType.CLIENT;
        }
        return LoaderManagerService.EnvironmentType.SERVER;
    }

    @Override
    public String getModVersion(String modId) {
        if (GlobalVariables.preload.booleanValue()) {
            if (modId.equals("minecraft")) {
                return FMLLoader.versionInfo().mcVersion();
            }
            List<ModFile> modFiles = LoadedMods.INSTANCE.candidateMods;
            for (ModFile modFile : modFiles) {
                if (modFile.getModFileInfo() == null || modFile.getModInfos().isEmpty() || !((IModInfo)modFile.getModInfos().get(0)).getModId().equals(modId)) continue;
                return ((IModInfo)modFile.getModInfos().get(0)).getVersion().toString();
            }
            return null;
        }
        ModInfo modInfo = FMLLoader.getLoadingModList().getMods().stream().filter(mod -> mod.getModId().equals(modId)).findFirst().orElse(null);
        if (modInfo == null) {
            return null;
        }
        return modInfo.getVersion().toString();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }
}

