/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pkcs;

import am_libs.org.bouncycastle.asn1.ASN1Object;
import am_libs.org.bouncycastle.asn1.ASN1OctetString;
import am_libs.org.bouncycastle.asn1.ASN1Primitive;
import am_libs.org.bouncycastle.asn1.ASN1Sequence;
import am_libs.org.bouncycastle.asn1.pkcs.ContentInfo;
import am_libs.org.bouncycastle.asn1.pkcs.MacData;
import am_libs.org.bouncycastle.asn1.pkcs.PBMAC1Params;
import am_libs.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import am_libs.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import am_libs.org.bouncycastle.asn1.pkcs.Pfx;
import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.pkcs.MacDataGenerator;
import am_libs.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import am_libs.org.bouncycastle.pkcs.PKCSException;
import am_libs.org.bouncycastle.pkcs.PKCSIOException;
import am_libs.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx pfx;

    private static Pfx parseBytes(byte[] byArray) throws IOException {
        try {
            return Pfx.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public PKCS12PfxPdu(byte[] byArray) throws IOException {
        this(PKCS12PfxPdu.parseBytes(byArray));
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] contentInfoArray = new ContentInfo[aSN1Sequence.size()];
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            contentInfoArray[i] = ContentInfo.getInstance(aSN1Sequence.getObjectAt(i));
        }
        return contentInfoArray;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public AlgorithmIdentifier getMacAlgorithmID() {
        MacData macData = this.pfx.getMacData();
        if (macData != null) {
            return macData.getMac().getAlgorithmId();
        }
        return null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider pKCS12MacCalculatorBuilderProvider, char[] cArray) throws PKCSException {
        if (this.hasMac()) {
            MacDataGenerator macDataGenerator;
            ASN1Object aSN1Object;
            MacData macData = this.pfx.getMacData();
            if (PKCSObjectIdentifiers.id_PBMAC1.equals(macData.getMac().getAlgorithmId().getAlgorithm())) {
                aSN1Object = PBMAC1Params.getInstance(macData.getMac().getAlgorithmId().getParameters());
                if (aSN1Object == null) {
                    throw new PKCSException("If the DigestAlgorithmIdentifier is id-PBMAC1, then the parameters field must contain valid PBMAC1-params parameters.");
                }
                macDataGenerator = new MacDataGenerator(pKCS12MacCalculatorBuilderProvider.get(new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), aSN1Object)));
            } else {
                macDataGenerator = new MacDataGenerator(pKCS12MacCalculatorBuilderProvider.get(new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), new PKCS12PBEParams(macData.getSalt(), macData.getIterationCount().intValue()))));
            }
            try {
                aSN1Object = macDataGenerator.build(cArray, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(aSN1Object.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException iOException) {
                throw new PKCSException("unable to process AuthSafe: " + iOException.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }

    public byte[] getEncoded() throws IOException {
        return this.toASN1Structure().getEncoded();
    }

    public byte[] getEncoded(String string) throws IOException {
        return this.toASN1Structure().getEncoded(string);
    }
}

