/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.oer.its.etsi103097.extension;

import am_libs.org.bouncycastle.asn1.ASN1Integer;
import am_libs.org.bouncycastle.asn1.ASN1Object;
import am_libs.org.bouncycastle.asn1.ASN1Primitive;
import java.math.BigInteger;

public class ExtId
extends ASN1Object {
    private final BigInteger extId;
    private static final BigInteger MAX = BigInteger.valueOf(255L);

    public ExtId(long l) {
        this(BigInteger.valueOf(l));
    }

    public ExtId(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.compareTo(MAX) > 0) {
            throw new IllegalArgumentException("value " + bigInteger + " outside of range 0...255");
        }
        this.extId = bigInteger;
    }

    public ExtId(byte[] byArray) {
        this(new BigInteger(byArray));
    }

    private ExtId(ASN1Integer aSN1Integer) {
        this(aSN1Integer.getValue());
    }

    public BigInteger getExtId() {
        return this.extId;
    }

    public static ExtId getInstance(Object object) {
        if (object instanceof ExtId) {
            return (ExtId)object;
        }
        if (object != null) {
            return new ExtId(ASN1Integer.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new ASN1Integer(this.extId);
    }
}

