/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto.kems;

import am_libs.org.bouncycastle.crypto.Digest;
import am_libs.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import am_libs.org.bouncycastle.crypto.kems.SAKKEKEMSGenerator;
import am_libs.org.bouncycastle.crypto.params.SAKKEPrivateKeyParameters;
import am_libs.org.bouncycastle.crypto.params.SAKKEPublicKeyParameters;
import am_libs.org.bouncycastle.math.ec.ECCurve;
import am_libs.org.bouncycastle.math.ec.ECPoint;
import am_libs.org.bouncycastle.util.Arrays;
import am_libs.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class SAKKEKEMExtractor
implements EncapsulatedSecretExtractor {
    private final ECCurve curve;
    private final BigInteger p;
    private final BigInteger q;
    private final ECPoint P;
    private final ECPoint Z_S;
    private final ECPoint K_bs;
    private final int n;
    private final BigInteger identifier;
    private final Digest digest;

    public SAKKEKEMExtractor(SAKKEPrivateKeyParameters sAKKEPrivateKeyParameters) {
        SAKKEPublicKeyParameters sAKKEPublicKeyParameters = sAKKEPrivateKeyParameters.getPublicParams();
        this.curve = sAKKEPublicKeyParameters.getCurve();
        this.q = sAKKEPublicKeyParameters.getQ();
        this.P = sAKKEPublicKeyParameters.getPoint();
        this.p = sAKKEPublicKeyParameters.getPrime();
        this.Z_S = sAKKEPublicKeyParameters.getZ();
        this.identifier = sAKKEPublicKeyParameters.getIdentifier();
        this.K_bs = this.P.multiply(this.identifier.add(sAKKEPrivateKeyParameters.getMasterSecret()).modInverse(this.q)).normalize();
        this.n = sAKKEPublicKeyParameters.getN();
        this.digest = sAKKEPublicKeyParameters.getDigest();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        ECPoint eCPoint = this.curve.decodePoint(Arrays.copyOfRange(byArray, 0, 257));
        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(byArray, 257, 16);
        BigInteger bigInteger2 = SAKKEKEMExtractor.computePairing(eCPoint, this.K_bs, this.p, this.q);
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(this.n);
        BigInteger bigInteger4 = SAKKEKEMSGenerator.hashToIntegerRange(bigInteger2.toByteArray(), bigInteger3, this.digest);
        BigInteger bigInteger5 = bigInteger.xor(bigInteger4).mod(this.p);
        BigInteger bigInteger6 = this.identifier;
        BigInteger bigInteger7 = SAKKEKEMSGenerator.hashToIntegerRange(Arrays.concatenate(bigInteger5.toByteArray(), bigInteger6.toByteArray()), this.q, this.digest);
        ECPoint eCPoint2 = this.P.multiply(bigInteger6).normalize();
        ECPoint eCPoint3 = eCPoint2.add(this.Z_S).multiply(bigInteger7).normalize();
        if (!eCPoint.equals(eCPoint3)) {
            throw new IllegalStateException("Validation of R_bS failed");
        }
        return BigIntegers.asUnsignedByteArray(this.n / 8, bigInteger5);
    }

    @Override
    public int getEncapsulationLength() {
        return 273;
    }

    static BigInteger computePairing(ECPoint eCPoint, ECPoint eCPoint2, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ONE, BigInteger.ZERO};
        ECPoint eCPoint3 = eCPoint;
        BigInteger bigInteger3 = bigInteger2.subtract(BigInteger.ONE);
        int n = bigInteger3.bitLength();
        BigInteger bigInteger4 = eCPoint2.getAffineXCoord().toBigInteger();
        BigInteger bigInteger5 = eCPoint2.getAffineYCoord().toBigInteger();
        BigInteger bigInteger6 = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger7 = eCPoint.getAffineYCoord().toBigInteger();
        BigInteger bigInteger8 = BigInteger.valueOf(3L);
        BigInteger bigInteger9 = BigInteger.valueOf(2L);
        for (int i = n - 2; i >= 0; --i) {
            BigInteger bigInteger10 = eCPoint3.getAffineXCoord().toBigInteger();
            BigInteger bigInteger11 = eCPoint3.getAffineYCoord().toBigInteger();
            BigInteger bigInteger12 = bigInteger8.multiply(bigInteger10.multiply(bigInteger10).subtract(BigInteger.ONE)).multiply(bigInteger11.multiply(bigInteger9).modInverse(bigInteger)).mod(bigInteger);
            bigIntegerArray = SAKKEKEMExtractor.fp2PointSquare(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
            bigIntegerArray = SAKKEKEMExtractor.fp2Multiply(bigIntegerArray[0], bigIntegerArray[1], bigInteger12.multiply(bigInteger4.add(bigInteger10)).subtract(bigInteger11), bigInteger5, bigInteger);
            eCPoint3 = eCPoint3.twice().normalize();
            if (!bigInteger3.testBit(i)) continue;
            bigInteger10 = eCPoint3.getAffineXCoord().toBigInteger();
            bigInteger11 = eCPoint3.getAffineYCoord().toBigInteger();
            bigInteger12 = bigInteger11.subtract(bigInteger7).multiply(bigInteger10.subtract(bigInteger6).modInverse(bigInteger)).mod(bigInteger);
            bigIntegerArray = SAKKEKEMExtractor.fp2Multiply(bigIntegerArray[0], bigIntegerArray[1], bigInteger12.multiply(bigInteger4.add(bigInteger10)).subtract(bigInteger11), bigInteger5, bigInteger);
            eCPoint3 = eCPoint3.add(eCPoint).normalize();
        }
        bigIntegerArray = SAKKEKEMExtractor.fp2PointSquare(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
        bigIntegerArray = SAKKEKEMExtractor.fp2PointSquare(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
        return bigIntegerArray[1].multiply(bigIntegerArray[0].modInverse(bigInteger)).mod(bigInteger);
    }

    static BigInteger[] fp2Multiply(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return new BigInteger[]{bigInteger.multiply(bigInteger3).subtract(bigInteger2.multiply(bigInteger4)).mod(bigInteger5), bigInteger.multiply(bigInteger4).add(bigInteger2.multiply(bigInteger3)).mod(bigInteger5)};
    }

    static BigInteger[] fp2PointSquare(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.add(bigInteger2).mod(bigInteger3);
        BigInteger bigInteger5 = bigInteger.subtract(bigInteger2).mod(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger2).multiply(BigInteger.valueOf(2L)).mod(bigInteger3);
        return new BigInteger[]{bigInteger6, bigInteger7};
    }
}

