/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cert.crmf;

import am_libs.org.bouncycastle.asn1.ASN1Integer;
import am_libs.org.bouncycastle.asn1.ASN1OctetString;
import am_libs.org.bouncycastle.asn1.DEROctetString;
import am_libs.org.bouncycastle.asn1.cmp.CMPCertificate;
import am_libs.org.bouncycastle.asn1.cmp.CertOrEncCert;
import am_libs.org.bouncycastle.asn1.cmp.CertResponse;
import am_libs.org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import am_libs.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import am_libs.org.bouncycastle.asn1.cms.EnvelopedData;
import am_libs.org.bouncycastle.asn1.crmf.EncryptedKey;
import am_libs.org.bouncycastle.cert.X509CertificateHolder;
import am_libs.org.bouncycastle.cert.crmf.CertificateResponse;
import am_libs.org.bouncycastle.cms.CMSEnvelopedData;

public class CertificateResponseBuilder {
    private final ASN1Integer certReqId;
    private final PKIStatusInfo statusInfo;
    private CertifiedKeyPair certKeyPair;
    private ASN1OctetString rspInfo;

    public CertificateResponseBuilder(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo) {
        this.certReqId = aSN1Integer;
        this.statusInfo = pKIStatusInfo;
    }

    public CertificateResponseBuilder withCertificate(X509CertificateHolder x509CertificateHolder) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new CMPCertificate(x509CertificateHolder.toASN1Structure())));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMPCertificate cMPCertificate) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(cMPCertificate));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMSEnvelopedData cMSEnvelopedData) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new EncryptedKey(EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent()))));
        return this;
    }

    public CertificateResponseBuilder withResponseInfo(byte[] byArray) {
        if (this.rspInfo != null) {
            throw new IllegalStateException("response info already set");
        }
        this.rspInfo = new DEROctetString(byArray);
        return this;
    }

    public CertificateResponse build() {
        return new CertificateResponse(new CertResponse(this.certReqId, this.statusInfo, this.certKeyPair, this.rspInfo));
    }
}

