/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.impl.async;

import am_libs.org.apache.hc.client5.http.HttpRoute;
import am_libs.org.apache.hc.client5.http.async.AsyncExecCallback;
import am_libs.org.apache.hc.client5.http.async.AsyncExecChain;
import am_libs.org.apache.hc.client5.http.async.AsyncExecRuntime;
import am_libs.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import am_libs.org.apache.hc.client5.http.auth.CredentialsProvider;
import am_libs.org.apache.hc.client5.http.config.Configurable;
import am_libs.org.apache.hc.client5.http.config.RequestConfig;
import am_libs.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import am_libs.org.apache.hc.client5.http.cookie.CookieStore;
import am_libs.org.apache.hc.client5.http.impl.ExecSupport;
import am_libs.org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase;
import am_libs.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import am_libs.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import am_libs.org.apache.hc.client5.http.protocol.HttpClientContext;
import am_libs.org.apache.hc.client5.http.routing.RoutingSupport;
import am_libs.org.apache.hc.core5.concurrent.Cancellable;
import am_libs.org.apache.hc.core5.concurrent.ComplexFuture;
import am_libs.org.apache.hc.core5.concurrent.DefaultThreadFactory;
import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpHost;
import am_libs.org.apache.hc.core5.http.HttpRequest;
import am_libs.org.apache.hc.core5.http.HttpResponse;
import am_libs.org.apache.hc.core5.http.config.Lookup;
import am_libs.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import am_libs.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import am_libs.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import am_libs.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import am_libs.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import am_libs.org.apache.hc.core5.http.nio.DataStreamChannel;
import am_libs.org.apache.hc.core5.http.nio.HandlerFactory;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.http.support.BasicRequestBuilder;
import am_libs.org.apache.hc.core5.io.CloseMode;
import am_libs.org.apache.hc.core5.io.ModalCloseable;
import am_libs.org.apache.hc.core5.net.URIAuthority;
import am_libs.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import am_libs.org.apache.hc.core5.util.TimeValue;
import am_libs.org.slf4j.Logger;
import am_libs.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

abstract class InternalAbstractHttpAsyncClient
extends AbstractHttpAsyncClientBase {
    private static final ThreadFactory SCHEDULER_THREAD_FACTORY = new DefaultThreadFactory("Scheduled-executor", true);
    private static final Logger LOG = LoggerFactory.getLogger(InternalAbstractHttpAsyncClient.class);
    private final AsyncExecChainElement execChain;
    private final Lookup<CookieSpecFactory> cookieSpecRegistry;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final Function<HttpContext, HttpClientContext> contextAdaptor;
    private final RequestConfig defaultConfig;
    private final ConcurrentLinkedQueue<Closeable> closeables;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AsyncExecChain.Scheduler scheduler;

    InternalAbstractHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, final AsyncExecChainElement execChain, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, Function<HttpContext, HttpClientContext> contextAdaptor, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory);
        this.execChain = execChain;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.contextAdaptor = contextAdaptor;
        this.defaultConfig = defaultConfig;
        this.closeables = closeables != null ? new ConcurrentLinkedQueue<Closeable>(closeables) : null;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(SCHEDULER_THREAD_FACTORY);
        this.scheduler = new AsyncExecChain.Scheduler(){

            @Override
            public void scheduleExecution(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecCallback asyncExecCallback, TimeValue delay) {
                InternalAbstractHttpAsyncClient.this.executeScheduled(request, entityProducer, scope, execChain::execute, asyncExecCallback, delay);
            }

            @Override
            public void scheduleExecution(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback, TimeValue delay) {
                InternalAbstractHttpAsyncClient.this.executeScheduled(request, entityProducer, scope, chain, asyncExecCallback, delay);
            }
        };
    }

    @Override
    void internalClose(CloseMode closeMode) {
        if (this.closeables != null) {
            Closeable closeable;
            while ((closeable = this.closeables.poll()) != null) {
                try {
                    if (closeable instanceof ModalCloseable) {
                        ((ModalCloseable)closeable).close(closeMode);
                        continue;
                    }
                    closeable.close();
                }
                catch (IOException ex) {
                    LOG.error(ex.getMessage(), ex);
                }
            }
        }
        List<Runnable> runnables = this.scheduledExecutorService.shutdownNow();
        for (Runnable runnable : runnables) {
            if (!(runnable instanceof Cancellable)) continue;
            ((Cancellable)((Object)runnable)).cancel();
        }
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAuthSchemeRegistry() == null) {
            context.setAuthSchemeRegistry(this.authSchemeRegistry);
        }
        if (context.getCookieSpecRegistry() == null) {
            context.setCookieSpecRegistry(this.cookieSpecRegistry);
        }
        if (context.getCookieStore() == null) {
            context.setCookieStore(this.cookieStore);
        }
        if (context.getCredentialsProvider() == null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        if (context.getRequestConfig() == null) {
            context.setRequestConfig(this.defaultConfig);
        }
    }

    abstract AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> var1);

    abstract HttpRoute determineRoute(HttpHost var1, HttpRequest var2, HttpClientContext var3) throws HttpException;

    @Override
    protected <T> Future<T> doExecute(HttpHost target, final AsyncRequestProducer requestProducer, final AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        final ComplexFuture future = new ComplexFuture(callback);
        try {
            if (!this.isRunning()) {
                throw new CancellationException("Request execution cancelled");
            }
            HttpClientContext clientContext = this.contextAdaptor.apply(context);
            requestProducer.sendRequest((request, entityDetails, c) -> {
                HttpHost resolvedTarget;
                RequestConfig requestConfig = null;
                if (request instanceof Configurable) {
                    requestConfig = ((Configurable)((Object)request)).getConfig();
                }
                if (requestConfig != null) {
                    clientContext.setRequestConfig(requestConfig);
                }
                this.setupContext(clientContext);
                HttpHost httpHost = resolvedTarget = target != null ? target : RoutingSupport.determineHost(request);
                if (resolvedTarget != null) {
                    if (request.getScheme() == null) {
                        request.setScheme(resolvedTarget.getSchemeName());
                    }
                    if (request.getAuthority() == null) {
                        request.setAuthority(new URIAuthority(resolvedTarget));
                    }
                }
                HttpRoute route = this.determineRoute(resolvedTarget, request, clientContext);
                final String exchangeId = ExecSupport.getNextExchangeId();
                clientContext.setExchangeId(exchangeId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} preparing request execution", (Object)exchangeId);
                }
                final AsyncExecRuntime execRuntime = this.createAsyncExecRuntime(pushHandlerFactory);
                AsyncExecChain.Scope scope = new AsyncExecChain.Scope(exchangeId, route, request, future, clientContext, execRuntime, this.scheduler, new AtomicInteger(1));
                final AtomicBoolean outputTerminated = new AtomicBoolean(false);
                this.executeImmediate(BasicRequestBuilder.copy(request).build(), entityDetails != null ? new AsyncEntityProducer(){

                    @Override
                    public void releaseResources() {
                        requestProducer.releaseResources();
                    }

                    @Override
                    public void failed(Exception cause) {
                        requestProducer.failed(cause);
                    }

                    @Override
                    public boolean isRepeatable() {
                        return requestProducer.isRepeatable();
                    }

                    @Override
                    public long getContentLength() {
                        return entityDetails.getContentLength();
                    }

                    @Override
                    public String getContentType() {
                        return entityDetails.getContentType();
                    }

                    @Override
                    public String getContentEncoding() {
                        return entityDetails.getContentEncoding();
                    }

                    @Override
                    public boolean isChunked() {
                        return entityDetails.isChunked();
                    }

                    @Override
                    public Set<String> getTrailerNames() {
                        return entityDetails.getTrailerNames();
                    }

                    @Override
                    public int available() {
                        return requestProducer.available();
                    }

                    @Override
                    public void produce(DataStreamChannel channel) throws IOException {
                        if (outputTerminated.get()) {
                            channel.endStream();
                            return;
                        }
                        requestProducer.produce(channel);
                    }
                } : null, scope, this.execChain::execute, new AsyncExecCallback(){

                    @Override
                    public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                        if (response.getCode() >= 400) {
                            outputTerminated.set(true);
                            requestProducer.releaseResources();
                        }
                        responseConsumer.consumeResponse(response, entityDetails, c, new FutureCallback<T>(){

                            @Override
                            public void completed(T result) {
                                future.completed(result);
                            }

                            @Override
                            public void failed(Exception ex) {
                                future.failed(ex);
                            }

                            @Override
                            public void cancelled() {
                                future.cancel();
                            }
                        });
                        return entityDetails != null ? responseConsumer : null;
                    }

                    @Override
                    public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                        responseConsumer.informationResponse(response, c);
                    }

                    @Override
                    public void completed() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} message exchange successfully completed", (Object)exchangeId);
                        }
                        try {
                            execRuntime.releaseEndpoint();
                        }
                        finally {
                            responseConsumer.releaseResources();
                            requestProducer.releaseResources();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failed(Exception cause) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} request failed: {}", (Object)exchangeId, (Object)cause.getMessage());
                        }
                        try {
                            execRuntime.discardEndpoint();
                            responseConsumer.failed(cause);
                        }
                        finally {
                            try {
                                future.failed(cause);
                            }
                            finally {
                                responseConsumer.releaseResources();
                                requestProducer.releaseResources();
                            }
                        }
                    }
                });
            }, clientContext);
        }
        catch (HttpException | IOException | IllegalStateException ex) {
            future.failed(ex);
        }
        return future;
    }

    void executeImmediate(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        chain.proceed(request, entityProducer, scope, asyncExecCallback);
    }

    void executeScheduled(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback, TimeValue delay) {
        ScheduledRequestExecution scheduledTask = new ScheduledRequestExecution(request, entityProducer, scope, chain, asyncExecCallback, delay);
        if (TimeValue.isPositive(delay)) {
            this.scheduledExecutorService.schedule(scheduledTask, delay.getDuration(), delay.getTimeUnit());
        } else {
            this.scheduledExecutorService.execute(scheduledTask);
        }
    }

    class ScheduledRequestExecution
    implements Runnable,
    Cancellable {
        final HttpRequest request;
        final AsyncEntityProducer entityProducer;
        final AsyncExecChain.Scope scope;
        final AsyncExecChain chain;
        final AsyncExecCallback asyncExecCallback;
        final TimeValue delay;

        ScheduledRequestExecution(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback, TimeValue delay) {
            this.request = request;
            this.entityProducer = entityProducer;
            this.scope = scope;
            this.chain = chain;
            this.asyncExecCallback = asyncExecCallback;
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                this.chain.proceed(this.request, this.entityProducer, this.scope, this.asyncExecCallback);
            }
            catch (Exception ex) {
                this.asyncExecCallback.failed(ex);
            }
        }

        @Override
        public boolean cancel() {
            this.asyncExecCallback.failed(new CancellationException("Request execution cancelled"));
            return true;
        }
    }
}

