/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.crypto.mldsa;

import am_libs.org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import am_libs.org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import am_libs.org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecMatrix {
    private final PolyVecL[] matrix;

    PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumK();
        this.matrix = new PolyVecL[n];
        for (int i = 0; i < n; ++i) {
            this.matrix[i] = new PolyVecL(mLDSAEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int i = 0; i < this.matrix.length; ++i) {
            polyVecK.getVectorIndex(i).pointwiseAccountMontgomery(this.matrix[i], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].uniformBlocks(byArray, i << 8);
        }
    }

    private String addString() {
        Object object = "[";
        for (int i = 0; i < this.matrix.length; ++i) {
            object = (String)object + "Outer Matrix " + i + " [";
            object = (String)object + this.matrix[i].toString();
            object = i == this.matrix.length - 1 ? (String)object + "]\n" : (String)object + "],\n";
        }
        object = (String)object + "]\n";
        return object;
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

