/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.illusivesoulworks.caelus.api.CaelusApi;
import com.illusivesoulworks.elytraslot.ElytraSlotCommonMod;
import com.illusivesoulworks.elytraslot.ElytraSlotNeoForgeClientMod;
import com.illusivesoulworks.elytraslot.common.CurioElytra;
import com.illusivesoulworks.elytraslot.common.integration.deeperdarker.DeeperDarkerPlugin;
import com.illusivesoulworks.elytraslot.platform.Services;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosCapability;

@Mod(value="elytraslot")
public class ElytraSlotNeoForgeMod {
    public ElytraSlotNeoForgeMod(IEventBus eventBus) {
        ElytraSlotCommonMod.init();
        eventBus.addListener(FMLClientSetupEvent.class, evt -> this.clientSetup((FMLClientSetupEvent)evt, eventBus));
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCapabilities);
        if (Services.PLATFORM.isModLoaded("deeperdarker")) {
            DeeperDarkerPlugin.setup(eventBus);
        }
    }

    private void setup(FMLCommonSetupEvent evt) {
        NeoForge.EVENT_BUS.addListener(this::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent evt, IEventBus eventBus) {
        ElytraSlotNeoForgeClientMod.setup(eventBus);
    }

    private void playerTick(PlayerTickEvent.Post evt) {
        Player player = evt.getEntity();
        AttributeInstance attributeInstance = player.getAttribute(CaelusApi.getInstance().getFallFlyingAttribute());
        if (attributeInstance != null) {
            attributeInstance.removeModifier(CurioElytra.ELYTRA_CURIO_MODIFIER.id());
            if (!attributeInstance.hasModifier(CurioElytra.ELYTRA_CURIO_MODIFIER.id()) && ElytraSlotCommonMod.canFly((LivingEntity)player)) {
                attributeInstance.addTransientModifier(CurioElytra.ELYTRA_CURIO_MODIFIER);
            }
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!ElytraSlotCommonMod.IS_ELYTRA.test(item.getDefaultInstance())) continue;
            evt.registerItem(CuriosCapability.ITEM, (stack, context) -> new CurioElytra((ItemStack)stack), new ItemLike[]{item});
        }
    }
}

