/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.BitSet;
import java.util.function.Function;
import mekanism.common.world.ResizableOreFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.jetbrains.annotations.NotNull;

public class ResizableOreFeature
extends Feature<ResizableOreFeatureConfig> {
    public ResizableOreFeature() {
        super(ResizableOreFeatureConfig.CODEC);
    }

    protected Heightmap.Types getHeightmapType() {
        return Heightmap.Types.OCEAN_FLOOR_WG;
    }

    public boolean place(@NotNull FeaturePlaceContext<ResizableOreFeatureConfig> context) {
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        WorldGenLevel world = context.level();
        ResizableOreFeatureConfig config = (ResizableOreFeatureConfig)context.config();
        float angle = random.nextFloat() * (float)Math.PI;
        float adjustedSize = (float)config.size().getAsInt() / 8.0f;
        int i = Mth.ceil((float)((adjustedSize + 1.0f) / 2.0f));
        double sin = Math.sin(angle) * (double)adjustedSize;
        double cos = Math.cos(angle) * (double)adjustedSize;
        double xMin = (double)pos.getX() + sin;
        double xMax = (double)pos.getX() - sin;
        double zMin = (double)pos.getZ() + cos;
        double zMax = (double)pos.getZ() - cos;
        double yMin = pos.getY() + random.nextInt(3) - 2;
        double yMax = pos.getY() + random.nextInt(3) - 2;
        int minXStart = pos.getX() - Mth.ceil((float)adjustedSize) - i;
        int minYStart = pos.getY() - 2 - i;
        int minZStart = pos.getZ() - Mth.ceil((float)adjustedSize) - i;
        int width = 2 * (Mth.ceil((float)adjustedSize) + i);
        int height = 2 * (2 + i);
        for (int x = minXStart; x <= minXStart + width; ++x) {
            for (int z = minZStart; z <= minZStart + width; ++z) {
                if (minYStart > world.getHeight(this.getHeightmapType(), x, z)) continue;
                return this.doPlace(world, random, config, xMin, xMax, zMin, zMax, yMin, yMax, minXStart, minYStart, minZStart, width, height);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, ResizableOreFeatureConfig config, double xMin, double xMax, double zMin, double zMax, double yMin, double yMax, int minXStart, int minYStart, int minZStart, int width, int height) {
        int i;
        BitSet bitset = new BitSet(width * height * width);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int size = config.size().getAsInt();
        double[] adouble = new double[size * 4];
        for (int k = 0; k < size; ++k) {
            float f = (float)k / (float)size;
            int k4 = k * 4;
            adouble[k4] = Mth.lerp((double)f, (double)xMin, (double)xMax);
            adouble[k4 + 1] = Mth.lerp((double)f, (double)yMin, (double)yMax);
            adouble[k4 + 2] = Mth.lerp((double)f, (double)zMin, (double)zMax);
            double d3 = random.nextDouble() * (double)size / 16.0;
            adouble[k4 + 3] = ((double)(Mth.sin((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
        }
        for (i = 0; i < size - 1; ++i) {
            int i4 = i * 4;
            if (!(adouble[i4 + 3] > 0.0)) continue;
            for (int j = i + 1; j < size; ++j) {
                double d3;
                double d2;
                double d1;
                double d4;
                int j4 = j * 4;
                if (!(adouble[j4 + 3] > 0.0) || !((d4 = adouble[i4 + 3] - adouble[j4 + 3]) * d4 > (d1 = adouble[i4] - adouble[j4]) * d1 + (d2 = adouble[i4 + 1] - adouble[j4 + 1]) * d2 + (d3 = adouble[i4 + 2] - adouble[j4 + 2]) * d3)) continue;
                if (d4 > 0.0) {
                    adouble[j4 + 3] = -1.0;
                    continue;
                }
                adouble[i4 + 3] = -1.0;
            }
        }
        i = 0;
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)world);){
            float discardChanceOnAirExposure = config.discardChanceOnAirExposure().getAsFloat();
            for (int j = 0; j < size; ++j) {
                int j4 = j * 4;
                double d1 = adouble[j4 + 3];
                if (!(d1 >= 0.0)) continue;
                double d2 = adouble[j4];
                double d3 = adouble[j4 + 1];
                double d4 = adouble[j4 + 2];
                int xStart = Math.max(Mth.floor((double)(d2 - d1)), minXStart);
                int yStart = Math.max(Mth.floor((double)(d3 - d1)), minYStart);
                int zStart = Math.max(Mth.floor((double)(d4 - d1)), minZStart);
                int xEnd = Math.max(Mth.floor((double)(d2 + d1)), xStart);
                int yEnd = Math.max(Mth.floor((double)(d3 + d1)), yStart);
                int zEnd = Math.max(Mth.floor((double)(d4 + d1)), zStart);
                for (int x = xStart; x <= xEnd; ++x) {
                    double d5 = ((double)x + 0.5 - d2) / d1;
                    double d5_squared = d5 * d5;
                    if (!(d5_squared < 1.0)) continue;
                    for (int y = yStart; y <= yEnd; ++y) {
                        double d6 = ((double)y + 0.5 - d3) / d1;
                        double d6_squared = d6 * d6;
                        if (!(d5_squared + d6_squared < 1.0)) continue;
                        block11: for (int z = zStart; z <= zEnd; ++z) {
                            LevelChunkSection section;
                            int l2;
                            double d7 = ((double)z + 0.5 - d4) / d1;
                            if (!(d5_squared + d6_squared + d7 * d7 < 1.0) || world.isOutsideBuildHeight(y) || bitset.get(l2 = x - minXStart + (y - minYStart) * width + (z - minZStart) * width * height)) continue;
                            bitset.set(l2);
                            mutablePos.set(x, y, z);
                            if (!world.ensureCanWrite((BlockPos)mutablePos) || (section = bulkSectionAccess.getSection((BlockPos)mutablePos)) == null) continue;
                            int sectionX = SectionPos.sectionRelative((int)x);
                            int sectionY = SectionPos.sectionRelative((int)y);
                            int sectionZ = SectionPos.sectionRelative((int)z);
                            BlockState state = section.getBlockState(sectionX, sectionY, sectionZ);
                            for (OreConfiguration.TargetBlockState targetState : config.targetStates()) {
                                if (!ResizableOreFeature.canPlaceOre(state, arg_0 -> ((BulkSectionAccess)bulkSectionAccess).getBlockState(arg_0), random, discardChanceOnAirExposure, targetState, mutablePos)) continue;
                                section.setBlockState(sectionX, sectionY, sectionZ, targetState.state, false);
                                ++i;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    private static boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, float discardChanceOnAirExposure, OreConfiguration.TargetBlockState targetState, BlockPos.MutableBlockPos mutablePos) {
        if (!targetState.target.test(state, random)) {
            return false;
        }
        if (ResizableOreFeature.shouldSkipAirCheck(random, discardChanceOnAirExposure)) {
            return true;
        }
        return !ResizableOreFeature.isAdjacentToAir(adjacentStateAccessor, (BlockPos)mutablePos);
    }

    private static boolean shouldSkipAirCheck(RandomSource random, float discardChanceOnAirExposure) {
        if (discardChanceOnAirExposure <= 0.0f) {
            return true;
        }
        if (discardChanceOnAirExposure >= 1.0f) {
            return false;
        }
        return random.nextFloat() >= discardChanceOnAirExposure;
    }
}

