/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mekanism.api.MekanismAPI;
import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.ITileComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.world.chunk.LoadingValidationCallback;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TileComponentChunkLoader<T extends TileEntityMekanism>
implements ITileComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final TicketController TICKET_CONTROLLER = new TicketController(Mekanism.rl("chunk_loader"), (LoadingValidationCallback)ChunkValidationCallback.INSTANCE);
    private final T tile;
    private final LongSet chunkSet = new LongOpenHashSet();
    private final boolean forceTicks;
    @Nullable
    private ServerLevel prevWorld;
    @Nullable
    private BlockPos prevPos;
    private boolean hasRegistered;

    public TileComponentChunkLoader(T tile) {
        this(tile, false);
    }

    public TileComponentChunkLoader(T tile, boolean forceTicks) {
        this.tile = tile;
        ((TileEntityMekanism)this.tile).addComponent(this);
        this.forceTicks = forceTicks;
    }

    public boolean canOperate() {
        return MekanismConfig.general.allowChunkloading.get() && ((TileEntityMekanism)this.tile).supportsUpgrades() && ((TileEntityMekanism)this.tile).getComponent().isUpgradeInstalled(Upgrade.ANCHOR);
    }

    private void releaseChunkTickets(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        int tickets = this.chunkSet.size();
        LOGGER.debug("Attempting to remove {} chunk tickets. Pos: {} World: {}", new Object[]{tickets, pos, world.dimension().location()});
        if (tickets > 0) {
            LongIterator longIterator = this.chunkSet.iterator();
            while (longIterator.hasNext()) {
                long chunkPos = (Long)longIterator.next();
                boolean success = TICKET_CONTROLLER.forceChunk(world, pos, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), false, this.forceTicks);
                if (success) continue;
                LOGGER.warn("Failed to release chunk ticket for {}", (Object)chunkPos);
            }
            this.chunkSet.clear();
            this.markDirty();
        }
        this.hasRegistered = false;
        this.prevWorld = null;
    }

    private void registerChunkTickets(@NotNull ServerLevel world) {
        this.prevPos = this.tile.getBlockPos();
        this.prevWorld = world;
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        int tickets = chunks.size();
        LOGGER.debug("Attempting to add {} chunk tickets. Pos: {} World: {}", new Object[]{tickets, this.prevPos, world.dimension().location()});
        if (tickets > 0) {
            for (ChunkPos chunkPos : chunks) {
                boolean success = TICKET_CONTROLLER.forceChunk(world, this.prevPos, chunkPos.x, chunkPos.z, true, this.forceTicks);
                this.chunkSet.add(chunkPos.toLong());
                if (success) continue;
                LOGGER.error("Failed to force chunk during registration {}", (Object)chunkPos);
            }
            this.markDirty();
        }
        this.hasRegistered = true;
    }

    public void refreshChunkTickets() {
        if (!((TileEntityUpdateable)this.tile).isRemote()) {
            this.refreshChunkTickets((ServerLevel)Objects.requireNonNull(this.tile.getLevel()), this.tile.getBlockPos(), true);
        }
    }

    private void refreshChunkTickets(@NotNull ServerLevel world, @NotNull BlockPos pos, boolean ticketsChanged) {
        boolean canOperate = this.canOperate();
        if (MekanismAPI.debug) {
            LOGGER.debug("refreshChunkTickets called for {}. Can operate = {}", (Object)pos, (Object)canOperate);
        }
        if (this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            if (this.prevWorld != world || !pos.equals((Object)this.prevPos)) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
                if (canOperate) {
                    this.registerChunkTickets(world);
                }
            } else if (!canOperate) {
                this.releaseChunkTickets(world, pos);
            } else if (ticketsChanged) {
                if (this.chunkSet.isEmpty()) {
                    this.registerChunkTickets(world);
                } else {
                    LongSet newChunks = this.getTileChunks();
                    if (newChunks.isEmpty()) {
                        this.releaseChunkTickets(world, pos);
                    } else {
                        int removed = 0;
                        int added = 0;
                        LongIterator chunkIt = this.chunkSet.iterator();
                        while (chunkIt.hasNext()) {
                            long chunkPos = chunkIt.nextLong();
                            if (newChunks.contains(chunkPos)) continue;
                            boolean success = TICKET_CONTROLLER.forceChunk(world, pos, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), false, this.forceTicks);
                            if (!success) {
                                LOGGER.warn("Failed to remove forced chunk {}", (Object)chunkPos);
                            }
                            chunkIt.remove();
                            ++removed;
                        }
                        LongIterator longIterator = newChunks.iterator();
                        while (longIterator.hasNext()) {
                            long chunkPos = (Long)longIterator.next();
                            if (!this.chunkSet.add(chunkPos)) continue;
                            boolean success = TICKET_CONTROLLER.forceChunk(world, pos, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), true, this.forceTicks);
                            if (!success) {
                                LOGGER.error("Failed to force chunk during refresh {}", (Object)chunkPos);
                            }
                            ++added;
                        }
                        if (removed != 0 || added != 0) {
                            this.markDirty();
                        }
                        LOGGER.debug("refreshChunkTickets(): Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", new Object[]{removed, added, pos, world.dimension().location()});
                        if (MekanismAPI.debug) {
                            LOGGER.debug("Current set: {}", (Object)this.chunkSet);
                            LOGGER.debug("Tile chunk: {}", (Object)ChunkPos.asLong((BlockPos)this.tile.getBlockPos()));
                            LOGGER.debug("Tile requested: {}", (Object)newChunks);
                        }
                    }
                }
            }
        } else if (canOperate) {
            this.registerChunkTickets(world);
        }
    }

    public void tickServer() {
        Level world = this.tile.getLevel();
        if (world != null) {
            this.refreshChunkTickets((ServerLevel)world, this.tile.getBlockPos(), false);
        }
    }

    @Override
    public String getComponentKey() {
        return "componentChunkLoader";
    }

    @Override
    public void deserialize(CompoundTag componentTag, HolderLookup.Provider provider) {
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    @Override
    public void read(CompoundTag nbtTags, HolderLookup.Provider provider) {
        if (!this.chunkSet.isEmpty()) {
            if (this.tile.hasLevel() && !((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
            } else {
                this.chunkSet.clear();
            }
        }
        for (long chunk : nbtTags.getLongArray("chunk_set")) {
            this.chunkSet.add(chunk);
        }
    }

    @Override
    public void write(CompoundTag nbtTags, HolderLookup.Provider provider) {
        if (!this.chunkSet.isEmpty()) {
            nbtTags.putLongArray("chunk_set", this.chunkSet.toLongArray());
        }
    }

    @Override
    public void removed() {
        if (!((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            this.releaseChunkTickets(this.prevWorld, this.prevPos);
        }
    }

    private void markDirty() {
        ((TileEntityUpdateable)this.tile).markForSave();
    }

    private LongSet getTileChunks() {
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        if (chunks.isEmpty()) {
            return LongSets.EMPTY_SET;
        }
        LongOpenHashSet chunksAsLongs = new LongOpenHashSet(chunks.size());
        for (ChunkPos chunkPos : chunks) {
            chunksAsLongs.add(chunkPos.toLong());
        }
        return chunksAsLongs;
    }

    public static class ChunkValidationCallback
    implements LoadingValidationCallback {
        public static final ChunkValidationCallback INSTANCE = new ChunkValidationCallback();

        private ChunkValidationCallback() {
        }

        public void validateTickets(@NotNull ServerLevel world, @NotNull TicketHelper ticketHelper) {
            ResourceLocation worldName = world.dimension().location();
            LOGGER.debug("Validating tickets for: {}. Blocks: {}, Entities: {}", new Object[]{worldName, ticketHelper.getBlockTickets().size(), ticketHelper.getEntityTickets().size()});
            for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                LongSet forcedChunks = ((TicketSet)entry.getValue()).nonTicking();
                LongSet tickingForcedChunks = ((TicketSet)entry.getValue()).ticking();
                LOGGER.debug("Validating tickets for: {}, BlockPos: {}, Forced chunks: {}, Ticking forced chunks: {}", new Object[]{worldName, pos, forcedChunks.size(), tickingForcedChunks.size()});
                this.validateTickets(world, worldName, pos, ticketHelper, forcedChunks, false);
                this.validateTickets(world, worldName, pos, ticketHelper, tickingForcedChunks, true);
            }
        }

        private void validateTickets(ServerLevel world, ResourceLocation worldName, BlockPos pos, TicketHelper ticketHelper, LongSet forcedChunks, boolean ticking) {
            int ticketCount = forcedChunks.size();
            if (ticketCount > 0) {
                BlockEntity tile = world.getBlockEntity(pos);
                if (tile instanceof IChunkLoader) {
                    TileComponentChunkLoader<?> chunkLoader = ((IChunkLoader)tile).getChunkLoader();
                    if (chunkLoader.canOperate()) {
                        LongSet chunks;
                        if (!forcedChunks.equals((Object)chunkLoader.chunkSet)) {
                            LOGGER.debug("Mismatched chunkSet for chunk loader at position: {} in {}. Correcting.", (Object)pos, (Object)worldName);
                            chunkLoader.chunkSet.clear();
                            chunkLoader.chunkSet.addAll((LongCollection)forcedChunks);
                            chunkLoader.markDirty();
                        }
                        if ((chunks = chunkLoader.getTileChunks()).isEmpty()) {
                            LOGGER.warn("Removing {} chunk tickets as they are no longer valid as this loader does not expect to have any tickets even though it is can operate. Pos: {} World: {}", new Object[]{ticketCount, pos, worldName});
                            this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                        } else {
                            int removed = 0;
                            int added = 0;
                            LongIterator chunkIt = chunkLoader.chunkSet.iterator();
                            while (chunkIt.hasNext()) {
                                long chunkPos = chunkIt.nextLong();
                                if (chunks.contains(chunkPos) && ticking == chunkLoader.forceTicks) continue;
                                ticketHelper.removeTicket(pos, chunkPos, ticking);
                                chunkIt.remove();
                                ++removed;
                            }
                            LongIterator longIterator = chunks.iterator();
                            while (longIterator.hasNext()) {
                                long chunkPos = (Long)longIterator.next();
                                if (!chunkLoader.chunkSet.add(chunkPos) && ticking == chunkLoader.forceTicks) continue;
                                TICKET_CONTROLLER.forceChunk(world, pos, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), true, chunkLoader.forceTicks);
                                ++added;
                            }
                            chunkLoader.hasRegistered = true;
                            chunkLoader.prevWorld = world;
                            chunkLoader.prevPos = pos;
                            if (removed == 0 && added == 0) {
                                LOGGER.debug("Tickets for position: {} in {}, successfully validated.", (Object)pos, (Object)worldName);
                            } else {
                                chunkLoader.markDirty();
                                LOGGER.info("validateTickets(): Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", new Object[]{removed, added, pos, worldName});
                            }
                        }
                    } else {
                        LOGGER.info("Removing {} chunk tickets as they are no longer valid as this loader cannot operate. Pos: {} World: {}", new Object[]{ticketCount, pos, worldName});
                        this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                    }
                } else {
                    LOGGER.warn("Block at {}, in {}, is not a valid chunk loader. Removing {} chunk tickets.", new Object[]{pos, worldName, ticketCount});
                    ticketHelper.removeAllTickets(pos);
                }
            }
        }

        private void releaseAllTickets(TileComponentChunkLoader<?> chunkLoader, BlockPos pos, TicketHelper ticketHelper) {
            ticketHelper.removeAllTickets(pos);
            chunkLoader.chunkSet.clear();
            chunkLoader.hasRegistered = false;
            chunkLoader.prevWorld = null;
            chunkLoader.markDirty();
        }
    }
}

