/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.ICapabilityHandlerManager;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityTileEntity
extends TileEntityUpdateable {
    public static final ICapabilityProvider<CapabilityTileEntity, @Nullable Direction, IChemicalHandler> CHEMICAL_HANDLER_PROVIDER = CapabilityTileEntity.basicCapabilityProvider(Capabilities.CHEMICAL.block());
    public static final ICapabilityProvider<CapabilityTileEntity, @Nullable Direction, IHeatHandler> HEAT_HANDLER_PROVIDER = CapabilityTileEntity.basicCapabilityProvider(Capabilities.HEAT);
    public static final ICapabilityProvider<CapabilityTileEntity, @Nullable Direction, IItemHandler> ITEM_HANDLER_PROVIDER = CapabilityTileEntity.basicCapabilityProvider(Capabilities.ITEM.block());
    public static final ICapabilityProvider<CapabilityTileEntity, @Nullable Direction, IFluidHandler> FLUID_HANDLER_PROVIDER = CapabilityTileEntity.basicCapabilityProvider(Capabilities.FLUID.block());
    private final CapabilityCache capabilityCache = new CapabilityCache();

    public static <CAP> ICapabilityProvider<CapabilityTileEntity, @Nullable Direction, CAP> basicCapabilityProvider(BlockCapability<CAP, @Nullable Direction> capability) {
        return (tile, context) -> {
            if (tile.capabilityCache.isCapabilityDisabled(capability, (Direction)context)) {
                return null;
            }
            ICapabilityResolver<@Nullable Direction> resolver = tile.capabilityCache.getResolver(capability);
            return resolver == null ? null : resolver.resolve(capability, (Direction)context);
        };
    }

    public static <TILE extends CapabilityTileEntity, CAP> ICapabilityProvider<TILE, @Nullable Direction, CAP> capabilityProvider(BlockCapability<CAP, @Nullable Direction> capability, BiFunction<TILE, BlockCapability<CAP, @Nullable Direction>, ICapabilityResolver<@Nullable Direction>> resolverGetter) {
        return (tile, context) -> {
            CapabilityCache capabilityCache = tile.capabilityCache;
            if (capabilityCache.isCapabilityDisabled(capability, (Direction)context)) {
                return null;
            }
            return capabilityCache.getResolver(capability, () -> (ICapabilityResolver)resolverGetter.apply(tile, capability)).resolve(capability, (Direction)context);
        };
    }

    public CapabilityTileEntity(TileEntityTypeRegistryObject<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected final void addCapabilityResolvers(List<ICapabilityHandlerManager<?>> capabilityHandlerManagers) {
        for (ICapabilityHandlerManager<?> capabilityHandlerManager : capabilityHandlerManagers) {
            if (!capabilityHandlerManager.canHandle()) continue;
            this.capabilityCache.addCapabilityResolver(capabilityHandlerManager);
        }
    }

    protected final void addCapabilityResolver(ICapabilityResolver<@Nullable Direction> resolver) {
        this.capabilityCache.addCapabilityResolver(resolver);
    }

    protected final void addConfigComponent(TileComponentConfig config) {
        this.capabilityCache.addConfigComponent(config);
    }

    public void invalidateCapabilitiesFull() {
        BlockState state;
        AttributeHasBounding attribute;
        this.capabilityCache.invalidateAll();
        this.invalidateCapabilities();
        if (this.level != null && (attribute = Attribute.get(state = this.getBlockState(), AttributeHasBounding.class)) != null) {
            attribute.handle(this.level, this.worldPosition, state, null, (world, pos, ignoredData) -> {
                world.invalidateCapabilities(pos);
                return true;
            });
        }
    }

    public void setRemoved() {
        this.capabilityCache.invalidateAll();
        super.setRemoved();
    }

    public void clearRemoved() {
        this.capabilityCache.invalidateAll();
        super.clearRemoved();
    }

    public final void invalidateCapability(@NotNull BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        this.capabilityCache.invalidate(capability, side);
        this.invalidateCapabilities();
    }

    public final void invalidateCapabilityAll(@NotNull BlockCapability<?, @Nullable Direction> capability) {
        this.capabilityCache.invalidateAll(capability);
        this.invalidateCapabilities();
    }

    public final void invalidateCapabilities(@NotNull Collection<BlockCapability<?, @Nullable Direction>> capabilities, @Nullable Direction side) {
        for (BlockCapability<?, Direction> capability : capabilities) {
            this.capabilityCache.invalidate(capability, side);
        }
        this.invalidateCapabilities();
    }

    public final void invalidateCapabilitiesAll(@NotNull Collection<BlockCapability<?, @Nullable Direction>> capabilities) {
        for (BlockCapability<?, Direction> capability : capabilities) {
            this.capabilityCache.invalidateAll(capability);
        }
        this.invalidateCapabilities();
    }
}

