/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@NothingNullByDefault
public final class DataMapTypeRegister {
    private final String namespace;
    private final List<DataMapType<?, ?>> types = new ArrayList();

    public DataMapTypeRegister(String namespace) {
        this.namespace = namespace;
    }

    public <R, T> DataMapType<R, T> register(ResourceLocation name, ResourceKey<Registry<R>> registryKey, Codec<T> codec, UnaryOperator<DataMapType.Builder<T, R>> builder) {
        if (name.getNamespace().equals(this.namespace)) {
            DataMapType type = ((DataMapType.Builder)builder.apply(DataMapType.builder((ResourceLocation)name, registryKey, codec))).build();
            this.types.add(type);
            return type;
        }
        throw new IllegalArgumentException("Trying to register data map type with the wrong namespace. Expected: '" + this.namespace + "', but received: '" + name.getNamespace() + "'");
    }

    public <R, T> DataMapType<R, T> registerSynced(ResourceLocation name, ResourceKey<Registry<R>> registryKey, Codec<T> codec, Codec<T> networkCodec) {
        return this.register(name, registryKey, codec, builder -> builder.synced(networkCodec, true));
    }

    public <R, T> DataMapType<R, T> registerSimpleSynced(ResourceLocation name, ResourceKey<Registry<R>> registryKey, Codec<T> codec) {
        return this.registerSynced(name, registryKey, codec, codec);
    }

    public <R, T> DataMapType<R, T> registerSimple(ResourceLocation name, ResourceKey<Registry<R>> registryKey, Codec<T> codec) {
        return this.register(name, registryKey, codec, UnaryOperator.identity());
    }

    public void register(IEventBus bus) {
        bus.addListener(RegisterDataMapTypesEvent.class, event -> this.types.forEach(arg_0 -> ((RegisterDataMapTypesEvent)event).register(arg_0)));
    }
}

