/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.item.block.ItemBlockPersonalStorage;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ItemRecipeData
implements RecipeUpgradeData<ItemRecipeData> {
    private final List<IInventorySlot> slots;

    ItemRecipeData(List<IInventorySlot> slots) {
        this.slots = slots;
    }

    @Override
    @Nullable
    public ItemRecipeData merge(ItemRecipeData other) {
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots);
        allSlots.addAll(other.slots);
        return new ItemRecipeData(allSlots);
    }

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        if (this.slots.isEmpty()) {
            return true;
        }
        if (stack.getItem() instanceof ItemBlockPersonalStorage) {
            final ArrayList<IInventorySlot> stackSlots = new ArrayList<IInventorySlot>();
            PersonalStorageManager.createSlots(stackSlots::add, ConstantPredicates.alwaysTrueBi(), null);
            IMekanismInventory outputHandler = new IMekanismInventory(){

                @Override
                @NotNull
                public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
                    return stackSlots;
                }

                @Override
                public void onContentsChanged() {
                }
            };
            if (ItemRecipeData.applyToStack(outputHandler, this.slots)) {
                return PersonalStorageManager.createInventoryFor(provider, stack, stackSlots);
            }
            return false;
        }
        IMekanismInventory outputHandler = ContainerType.ITEM.createHandler(stack);
        return outputHandler != null && ItemRecipeData.applyToStack(outputHandler, this.slots);
    }

    static boolean applyToStack(IMekanismInventory outputHandler, List<IInventorySlot> dataSlots) {
        for (IInventorySlot slot : dataSlots) {
            if (slot.isEmpty() || ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)slot.getStack(), (boolean)false).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

