/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotTake(UUID typeUUID, int count) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketQIOItemViewerSlotTake> TYPE = new CustomPacketPayload.Type(Mekanism.rl("qio_take"));
    public static final StreamCodec<ByteBuf, PacketQIOItemViewerSlotTake> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PacketQIOItemViewerSlotTake::typeUUID, (StreamCodec)ByteBufCodecs.VAR_INT, PacketQIOItemViewerSlotTake::count, PacketQIOItemViewerSlotTake::new);

    @NotNull
    public CustomPacketPayload.Type<PacketQIOItemViewerSlotTake> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        HashedItem itemType;
        QIOItemViewerContainer container;
        QIOFrequency freq;
        AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
        if (abstractContainerMenu instanceof QIOItemViewerContainer && (freq = (container = (QIOItemViewerContainer)abstractContainerMenu).getFrequency()) != null && (itemType = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(this.typeUUID)) != null) {
            ItemStack extracted;
            ItemStack curStack = container.getCarried();
            int toRemove = Math.min(this.count, itemType.getMaxStackSize() - curStack.getCount());
            if (toRemove > 0 && InventoryUtils.areItemsStackable(curStack, itemType.getInternalStack()) && !(extracted = freq.removeByType(itemType, toRemove)).isEmpty()) {
                if (curStack.isEmpty()) {
                    container.setCarried(extracted);
                } else {
                    curStack.grow(extracted.getCount());
                }
            }
        }
    }
}

