/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record BulkQIOData(Map<UUID, QIOItemViewerContainer.ItemSlotData> inventory, long countCapacity, int typeCapacity, long totalItems, List<ISlotClickHandler.IScrollableSlot> items) {
    public static final BulkQIOData INITIAL_SERVER = new BulkQIOData(Collections.emptyMap(), 0L, 0, 0L, Collections.emptyList());

    public static void encodeToPacket(RegistryFriendlyByteBuf buffer, @Nullable QIOFrequency frequency) {
        buffer.writeBoolean(frequency != null);
        if (frequency != null) {
            Map<HashedItem, QIOFrequency.QIOItemTypeData> itemDataMap = frequency.getItemDataMap();
            buffer.writeVarInt(itemDataMap.size());
            for (QIOFrequency.QIOItemTypeData data : itemDataMap.values()) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)data.getItemType().getInternalStack());
                buffer.writeUUID(data.getItemUUID());
                buffer.writeVarLong(data.getCount());
            }
            buffer.writeVarLong(frequency.getTotalItemCountCapacity());
            buffer.writeVarInt(frequency.getTotalItemTypeCapacity());
        }
    }

    public static BulkQIOData fromPacket(RegistryFriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            long totalItems = 0L;
            int itemMapSize = buffer.readVarInt();
            ReferenceArrayList itemList = new ReferenceArrayList(itemMapSize);
            Object2ObjectOpenHashMap inventory = new Object2ObjectOpenHashMap(itemMapSize);
            for (int i = 0; i < itemMapSize; ++i) {
                QIOItemViewerContainer.ItemSlotData slotData = new QIOItemViewerContainer.ItemSlotData((HashedItem.UUIDAwareHashedItem)HashedItem.UUIDAwareHashedItem.STREAM_CODEC.decode((Object)buffer), buffer.readVarLong());
                totalItems += slotData.count();
                itemList.add(slotData);
                inventory.put(slotData.itemUUID(), slotData);
            }
            return new BulkQIOData((Map<UUID, QIOItemViewerContainer.ItemSlotData>)inventory, buffer.readVarLong(), buffer.readVarInt(), totalItems, (List<ISlotClickHandler.IScrollableSlot>)itemList);
        }
        return new BulkQIOData((Map<UUID, QIOItemViewerContainer.ItemSlotData>)new Object2ObjectOpenHashMap(), 0L, 0, 0L, (List<ISlotClickHandler.IScrollableSlot>)new ReferenceArrayList());
    }
}

