/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.EnumColor;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.sounds.SoundEvent;

public enum RadiationScale {
    NONE,
    LOW,
    MEDIUM,
    ELEVATED,
    HIGH,
    EXTREME;

    private static final double LOG_BASELINE;
    private static final double LOG_MAX;
    private static final double SCALE;

    public static RadiationScale get(double magnitude) {
        if (magnitude < 1.0E-5) {
            return NONE;
        }
        if (magnitude < 0.001) {
            return LOW;
        }
        if (magnitude < 0.1) {
            return MEDIUM;
        }
        if (magnitude < 10.0) {
            return ELEVATED;
        }
        if (magnitude < 100.0) {
            return HIGH;
        }
        return EXTREME;
    }

    public static EnumColor getSeverityColor(double magnitude) {
        if (magnitude <= IRadiationManager.INSTANCE.baselineRadiation()) {
            return EnumColor.BRIGHT_GREEN;
        }
        if (magnitude < 1.0E-5) {
            return EnumColor.GRAY;
        }
        if (magnitude < 0.001) {
            return EnumColor.YELLOW;
        }
        if (magnitude < 0.1) {
            return EnumColor.ORANGE;
        }
        if (magnitude < 10.0) {
            return EnumColor.RED;
        }
        return EnumColor.DARK_RED;
    }

    public static double getScaledDoseSeverity(double magnitude) {
        if (magnitude < IRadiationManager.INSTANCE.minRadiationMagnitude()) {
            return 0.0;
        }
        return Math.min(1.0, Math.max(0.0, (-LOG_BASELINE + Math.log10(magnitude)) / SCALE));
    }

    public SoundEvent getSoundEvent() {
        return switch (this.ordinal()) {
            case 1 -> (SoundEvent)MekanismSounds.GEIGER_SLOW.get();
            case 2 -> (SoundEvent)MekanismSounds.GEIGER_MEDIUM.get();
            case 3, 4 -> (SoundEvent)MekanismSounds.GEIGER_ELEVATED.get();
            case 5 -> (SoundEvent)MekanismSounds.GEIGER_FAST.get();
            default -> null;
        };
    }

    static {
        LOG_BASELINE = Math.log10(RadiationManager.get().minRadiationMagnitude());
        LOG_MAX = Math.log10(100.0);
        SCALE = LOG_MAX - LOG_BASELINE;
    }
}

