/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.collection;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LRU<T>
extends AbstractCollection<T> {
    private final Map<T, LRUEntry<T>> lookupMap = new Object2ObjectOpenHashMap();
    private final LRUEntry<T> head = new LRUEntry<Object>(null);
    private final LRUEntry<T> tail = new LRUEntry<Object>(null);
    private int size;

    public LRU() {
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    private void removeEntry(LRUEntry<T> entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
        --this.size;
        this.lookupMap.remove(entry.value);
    }

    private void addFirst(LRUEntry<T> entry) {
        entry.prev = this.head;
        entry.next = this.head.next;
        entry.next.prev = entry;
        this.head.next = entry;
        ++this.size;
        this.lookupMap.put(entry.value, entry);
    }

    @Override
    public boolean add(T element) {
        this.addFirst(new LRUEntry<T>(element));
        return true;
    }

    public void moveUp(T element) {
        LRUEntry<T> entry = this.lookupMap.get(element);
        if (entry == null) {
            return;
        }
        this.removeEntry(entry);
        this.addFirst(entry);
    }

    @Override
    public boolean remove(Object element) {
        LRUEntry<T> entry = this.lookupMap.get(element);
        if (entry == null) {
            return false;
        }
        this.removeEntry(entry);
        return true;
    }

    @Override
    public boolean contains(Object element) {
        return this.lookupMap.containsKey(element);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void reverseIterate(Consumer<T> callback) {
        LRUEntry ptr = this.tail.prev;
        while (ptr != this.head) {
            callback.accept(ptr.value);
            ptr = ptr.prev;
        }
    }

    @NotNull
    public T head() {
        if (this.head.next.value == null) {
            throw new NoSuchElementException("No entries");
        }
        return this.head.next.value;
    }

    @Nullable
    public T peek() {
        return this.head.next.value;
    }

    @NotNull
    public LRUIterator iterator() {
        return new LRUIterator();
    }

    public LRUIterator descendingIterator() {
        return new LRUIterator().reverse();
    }

    private static class LRUEntry<T> {
        private final T value;
        private LRUEntry<T> prev;
        private LRUEntry<T> next;

        private LRUEntry(T value) {
            this.value = value;
        }
    }

    public class LRUIterator
    implements Iterator<T> {
        boolean reverse = false;
        LRUEntry<T> curEntry;

        public LRUIterator() {
            this.curEntry = LRU.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.curEntry.prev != LRU.this.head : this.curEntry.next != LRU.this.tail;
        }

        @Override
        public T next() {
            if (this.reverse) {
                this.curEntry = this.curEntry.prev;
                if (this.curEntry == LRU.this.head) {
                    throw new NoSuchElementException("Reached beginning of LRU");
                }
            } else {
                this.curEntry = this.curEntry.next;
                if (this.curEntry == LRU.this.tail) {
                    throw new NoSuchElementException("Reached end of LRU");
                }
            }
            return this.curEntry == null ? null : (Object)this.curEntry.value;
        }

        public LRUIterator reverse() {
            this.reverse = true;
            this.curEntry = LRU.this.tail;
            return this;
        }
    }
}

