/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.Mekanism;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyInventorySlot
extends BasicInventorySlot {
    public static final Predicate<ItemStack> DRAIN_VALIDATOR = EnergyCompatUtils::hasStrictEnergyHandler;
    private final Supplier<@Nullable Level> worldSupplier;
    private final IEnergyContainer energyContainer;

    public static long getPotentialConversion(@Nullable Level world, ItemStack itemStack) {
        ItemStackToEnergyRecipe foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findTypeBasedRecipe(world, itemStack);
        return foundRecipe == null ? 0L : foundRecipe.getOutput(itemStack);
    }

    public static EnergyInventorySlot fillOrConvert(IEnergyContainer energyContainer, Supplier<@Nullable Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        return new EnergyInventorySlot(energyContainer, worldSupplier, stack -> !EnergyInventorySlot.fillInsertCheck(stack) && EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack) == 0L, stack -> {
            if (EnergyInventorySlot.fillInsertCheck(stack)) {
                return true;
            }
            return EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack) > 0L;
        }, stack -> EnergyCompatUtils.hasStrictEnergyHandler(stack) || EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack) > 0L, listener, x, y);
    }

    public static EnergyInventorySlot fill(IEnergyContainer energyContainer, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        return new EnergyInventorySlot(energyContainer, stack -> !EnergyInventorySlot.fillInsertCheck(stack), EnergyInventorySlot::fillInsertCheck, EnergyCompatUtils::hasStrictEnergyHandler, listener, x, y);
    }

    public static EnergyInventorySlot drain(IEnergyContainer energyContainer, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = stack -> {
            IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
            if (itemEnergyHandler == null) {
                return false;
            }
            long storedEnergy = energyContainer.getEnergy();
            if (storedEnergy == 0L) {
                for (int container = 0; container < itemEnergyHandler.getEnergyContainerCount(); ++container) {
                    if (itemEnergyHandler.getNeededEnergy(container) <= 0L) continue;
                    return true;
                }
                return false;
            }
            return itemEnergyHandler.insertEnergy(storedEnergy, Action.SIMULATE) < storedEnergy;
        };
        return new EnergyInventorySlot(energyContainer, insertPredicate.negate(), insertPredicate, DRAIN_VALIDATOR, listener, x, y);
    }

    public static boolean fillInsertCheck(ItemStack stack) {
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        return itemEnergyHandler != null && itemEnergyHandler.extractEnergy(Long.MAX_VALUE, Action.SIMULATE) > 0L;
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this(energyContainer, () -> null, canExtract, canInsert, validator, listener, x, y);
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Supplier<@Nullable Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.energyContainer = energyContainer;
        this.worldSupplier = worldSupplier;
        this.setSlotType(ContainerSlotType.POWER);
        this.setSlotOverlay(SlotOverlay.POWER);
    }

    public void fillContainerOrConvert() {
        long output;
        ItemStack itemInput;
        ItemStackToEnergyRecipe foundRecipe;
        if (!(this.isEmpty() || this.energyContainer.getNeeded() <= 0L || this.fillContainerFromItem() || (foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findFirstRecipe(this.worldSupplier.get(), this.current)) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).isEmpty() || this.energyContainer.insert(output = foundRecipe.getOutput(itemInput), Action.SIMULATE, AutomationType.MANUAL) != 0L)) {
            MekanismUtils.logExpectedZero(this.energyContainer.insert(output, Action.EXECUTE, AutomationType.MANUAL));
            int amountUsed = itemInput.getCount();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillContainer() {
        if (!this.isEmpty() && this.energyContainer.getNeeded() > 0L) {
            this.fillContainerFromItem();
        }
    }

    private boolean fillContainerFromItem() {
        long simulatedRemainder;
        long energyInItem;
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current);
        if (itemEnergyHandler != null && (energyInItem = itemEnergyHandler.extractEnergy(this.energyContainer.getNeeded(), Action.SIMULATE)) > 0L && (simulatedRemainder = this.energyContainer.insert(energyInItem, Action.SIMULATE, AutomationType.INTERNAL)) < energyInItem) {
            long toPull = energyInItem - simulatedRemainder;
            if ((simulatedRemainder = this.energyContainer.insert(toPull, Action.SIMULATE, AutomationType.INTERNAL)) == 0L) {
                long extractedEnergy = itemEnergyHandler.extractEnergy(toPull, Action.EXECUTE);
                if (extractedEnergy > 0L) {
                    MekanismUtils.logExpectedZero(this.energyContainer.insert(extractedEnergy, Action.EXECUTE, AutomationType.INTERNAL));
                    this.onContentsChanged();
                    return true;
                }
            } else {
                Mekanism.logger.error("EnergyInventorySlot#fillContainerFromItem: Simulation after extraction calculation had a remainder. Tried pulling {}, remainder {}", (Object)toPull, (Object)simulatedRemainder);
            }
        }
        return false;
    }

    public void drainContainer() {
        long storedEnergy;
        long simulatedRemainder;
        IStrictEnergyHandler itemEnergyHandler;
        if (!this.isEmpty() && !this.energyContainer.isEmpty() && (itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current)) != null && (simulatedRemainder = itemEnergyHandler.insertEnergy(storedEnergy = this.energyContainer.getEnergy(), Action.SIMULATE)) < storedEnergy) {
            long toOffer = storedEnergy - simulatedRemainder;
            if ((simulatedRemainder = itemEnergyHandler.insertEnergy(toOffer, Action.SIMULATE)) == 0L) {
                long extractedEnergy = this.energyContainer.extract(toOffer, Action.EXECUTE, AutomationType.INTERNAL);
                if (extractedEnergy > 0L) {
                    MekanismUtils.logExpectedZero(itemEnergyHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
                    this.onContentsChanged();
                }
            } else {
                Mekanism.logger.error("EnergyInventorySlot#drainContainer: Simulation after insertion calculation had a remainder. Offered {}, remainder {}", (Object)toOffer, (Object)simulatedRemainder);
            }
        }
    }
}

