/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.tile;

import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.qio.BulkQIOData;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.qio.TileEntityQIODashboard;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIODashboardContainer
extends QIOItemViewerContainer {
    private final TileEntityQIODashboard tile;

    public QIODashboardContainer(int id, Inventory inv, TileEntityQIODashboard tile, boolean remote, BulkQIOData itemData) {
        this(id, inv, tile, remote, itemData, remote ? QIOItemViewerContainer.CachedSearchData.initialClient() : QIOItemViewerContainer.CachedSearchData.INITIAL_SERVER, remote ? QIOItemViewerContainer.CachedSortingData.currentClient() : QIOItemViewerContainer.CachedSortingData.SERVER, null);
    }

    private QIODashboardContainer(int id, Inventory inv, TileEntityQIODashboard tile, boolean remote, BulkQIOData itemData, QIOItemViewerContainer.CachedSearchData searchData, QIOItemViewerContainer.CachedSortingData sortingData, @Nullable SelectedWindowData selectedWindow) {
        super(MekanismContainerTypes.QIO_DASHBOARD, id, inv, remote, tile, itemData, searchData, sortingData, selectedWindow);
        this.tile = tile;
        this.tile.addContainerTrackers(this);
        this.addSlotsAndOpen();
    }

    @Override
    protected QIODashboardContainer recreateUnchecked() {
        return new QIODashboardContainer(this.containerId, this.inv, this.tile, true, this.asBulkData(), this.asCachedSearchData(), this.currentSortingData(), this.getSelectedWindow());
    }

    @Override
    protected void openInventory(@NotNull Inventory inv) {
        super.openInventory(inv);
        this.tile.open(inv.player);
    }

    @Override
    protected void closeInventory(@NotNull Player player) {
        super.closeInventory(player);
        this.tile.close(player);
    }

    public boolean stillValid(@NotNull Player player) {
        return this.tile.hasGui() && !this.tile.isRemoved() && WorldUtils.isBlockLoaded((BlockGetter)this.tile.getLevel(), this.tile.getBlockPos());
    }

    public TileEntityQIODashboard getTileEntity() {
        return this.tile;
    }

    @Override
    public boolean shiftClickIntoFrequency() {
        return this.tile.shiftClickIntoFrequency();
    }

    @Override
    public void toggleTargetDirection() {
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TARGET_DIRECTION_BUTTON, this.tile));
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        Level level = this.tile.getLevel();
        if (level == null) {
            return false;
        }
        return IBlockSecurityUtils.INSTANCE.canAccess(player, level, this.tile.getBlockPos(), (BlockEntity)this.tile);
    }
}

