/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import com.mojang.datafixers.util.Function3;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.integration.projecte.NSSChemical;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.util.TriPredicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public abstract class TypedMekanismRecipeMapper<RECIPE extends Recipe<?>>
implements IRecipeTypeMapper {
    protected static final boolean OPTIMIZE_BASIC = true;
    private static final IntBinaryOperator MERGE = Integer::sum;
    private final Holder<RecipeType<?>>[] supportedTypes;
    private final IConfigTranslation configTranslation;
    private final Class<RECIPE> recipeClass;

    @SafeVarargs
    protected TypedMekanismRecipeMapper(IConfigTranslation configTranslation, Class<RECIPE> recipeClass, DeferredHolder<RecipeType<?>, ? extends RecipeType<? extends RECIPE>> ... supportedTypes) {
        this.configTranslation = configTranslation;
        this.supportedTypes = supportedTypes;
        this.recipeClass = recipeClass;
    }

    public final String getName() {
        return this.configTranslation.title();
    }

    public final String getTranslationKey() {
        return this.configTranslation.getTranslationKey();
    }

    public final String getDescription() {
        return this.configTranslation.tooltip();
    }

    public final boolean canHandle(RecipeType<?> recipeType) {
        for (Holder<RecipeType<?>> supportedType : this.supportedTypes) {
            if (supportedType.value() != recipeType) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> var1, RECIPE var2, MekFakeGroupHelper var3);

    public final boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        Recipe recipe = recipeHolder.value();
        if (this.recipeClass.isInstance(recipe) && !recipe.isIncomplete()) {
            return this.handleRecipe(mapper, (Recipe)this.recipeClass.cast(recipe), new MekFakeGroupHelper(fakeGroupManager));
        }
        return false;
    }

    protected static boolean addConversion(IMappingCollector<NormalizedSimpleStack, Long> mapper, ChemicalStack output, Object2IntMap<NormalizedSimpleStack> recipeInput) {
        if (!output.isEmpty() && !recipeInput.isEmpty() && output.getAmount() <= Integer.MAX_VALUE) {
            mapper.addConversion((int)output.getAmount(), (Object)NSSChemical.createChemical(output), recipeInput);
            return true;
        }
        return false;
    }

    protected static boolean addConversion(IMappingCollector<NormalizedSimpleStack, Long> mapper, FluidStack output, Object2IntMap<NormalizedSimpleStack> recipeInput) {
        if (!output.isEmpty() && !recipeInput.isEmpty()) {
            mapper.addConversion(output.getAmount(), (Object)NSSFluid.createFluid((FluidStack)output), recipeInput);
            return true;
        }
        return false;
    }

    protected static boolean addConversion(IMappingCollector<NormalizedSimpleStack, Long> mapper, ItemStack output, Object2IntMap<NormalizedSimpleStack> recipeInput) {
        if (!output.isEmpty() && !recipeInput.isEmpty()) {
            mapper.addConversion(output.getCount(), (Object)NSSItem.createItem((ItemStack)output), recipeInput);
            return true;
        }
        return false;
    }

    protected static <INPUT, OUTPUT> boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, InputIngredient<INPUT> inputs, Function<INPUT, OUTPUT> recipe, Predicate<OUTPUT> emptyChecker, Function<SequencedCollection<INPUT>, Object2IntMap<NormalizedSimpleStack>> toIngredient, @Nullable Hash.Strategy<? super OUTPUT> hashStrategy, TriPredicate<IMappingCollector<NormalizedSimpleStack, Long>, OUTPUT, Object2IntMap<NormalizedSimpleStack>> conversionAdder) {
        HashMap<Object, List> reverseLookup = hashStrategy == null ? new HashMap<Object, List>() : new Object2ObjectOpenCustomHashMap(hashStrategy);
        for (INPUT representation : inputs.getRepresentations()) {
            OUTPUT output = recipe.apply(representation);
            if (emptyChecker.test(output)) continue;
            reverseLookup.computeIfAbsent(output, k -> new ArrayList()).add(representation);
        }
        boolean handled = false;
        for (Map.Entry entry : reverseLookup.entrySet()) {
            handled |= conversionAdder.test(mapper, entry.getKey(), toIngredient.apply((SequencedCollection)entry.getValue()));
        }
        return handled;
    }

    protected static <INPUT_A, INPUT_B, OUTPUT> boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, InputIngredient<INPUT_A> inputA, InputIngredient<INPUT_B> inputB, BiFunction<INPUT_A, INPUT_B, OUTPUT> recipe, Predicate<OUTPUT> emptyChecker, Function<SequencedCollection<INPUT_A>, Object2IntMap<NormalizedSimpleStack>> toIngredientA, Function<SequencedCollection<INPUT_B>, Object2IntMap<NormalizedSimpleStack>> toIngredientB, @Nullable Hash.Strategy<? super OUTPUT> hashStrategy, TriPredicate<IMappingCollector<NormalizedSimpleStack, Long>, OUTPUT, Object2IntMap<NormalizedSimpleStack>> conversionAdder) {
        return TypedMekanismRecipeMapper.addConversions(mapper, inputA, inputB, recipe, emptyChecker, toIngredientA, toIngredientB, hashStrategy, conversionAdder, 1);
    }

    protected static <INPUT_A, INPUT_B, OUTPUT> boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, InputIngredient<INPUT_A> inputA, InputIngredient<INPUT_B> inputB, BiFunction<INPUT_A, INPUT_B, OUTPUT> recipe, Predicate<OUTPUT> emptyChecker, Function<SequencedCollection<INPUT_A>, Object2IntMap<NormalizedSimpleStack>> toIngredientA, Function<SequencedCollection<INPUT_B>, Object2IntMap<NormalizedSimpleStack>> toIngredientB, @Nullable Hash.Strategy<? super OUTPUT> hashStrategy, TriPredicate<IMappingCollector<NormalizedSimpleStack, Long>, OUTPUT, Object2IntMap<NormalizedSimpleStack>> conversionAdder, int secondaryInputScale) {
        final class InputDetails<INPUT_A, INPUT_B>
        extends Record {
            private final SequencedCollection<INPUT_A> aInputs;
            private final SequencedCollection<INPUT_B> bInputs;

            InputDetails() {
                this((SequencedCollection<INPUT_A>)new ReferenceLinkedOpenHashSet(), (SequencedCollection<INPUT_B>)new ReferenceLinkedOpenHashSet());
            }

            InputDetails(SequencedCollection<INPUT_A> aInputs, SequencedCollection<INPUT_B> bInputs) {
                this.aInputs = aInputs;
                this.bInputs = bInputs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{InputDetails.class, "aInputs;bInputs", "aInputs", "bInputs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InputDetails.class, "aInputs;bInputs", "aInputs", "bInputs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InputDetails.class, "aInputs;bInputs", "aInputs", "bInputs"}, this, o);
            }

            public SequencedCollection<INPUT_A> aInputs() {
                return this.aInputs;
            }

            public SequencedCollection<INPUT_B> bInputs() {
                return this.bInputs;
            }
        }
        HashMap<Object, InputDetails> reverseLookup = hashStrategy == null ? new HashMap<Object, InputDetails>() : new Object2ObjectOpenCustomHashMap(hashStrategy);
        List<INPUT_A> aRepresentations = inputA.getRepresentations();
        List<INPUT_B> bRepresentations = inputB.getRepresentations();
        for (INPUT_A aRepresentation : aRepresentations) {
            for (INPUT_B bRepresentation : bRepresentations) {
                OUTPUT output = recipe.apply(aRepresentation, bRepresentation);
                if (emptyChecker.test(output)) continue;
                InputDetails details = reverseLookup.computeIfAbsent(output, k -> new InputDetails());
                details.aInputs.add(aRepresentation);
                details.bInputs.add(bRepresentation);
            }
        }
        boolean handled = false;
        for (Map.Entry entry : reverseLookup.entrySet()) {
            InputDetails details = (InputDetails)entry.getValue();
            handled |= conversionAdder.test(mapper, entry.getKey(), TypedMekanismRecipeMapper.forIngredients(toIngredientA.apply(details.aInputs()), toIngredientB.apply(details.bInputs()), secondaryInputScale));
        }
        return handled;
    }

    protected static <INPUT_A, INPUT_B, INPUT_C, OUTPUT> boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, InputIngredient<INPUT_A> inputA, InputIngredient<INPUT_B> inputB, InputIngredient<INPUT_C> inputC, Function3<INPUT_A, INPUT_B, INPUT_C, OUTPUT> recipe, Predicate<OUTPUT> emptyChecker, Function<SequencedCollection<INPUT_A>, Object2IntMap<NormalizedSimpleStack>> toIngredientA, Function<SequencedCollection<INPUT_B>, Object2IntMap<NormalizedSimpleStack>> toIngredientB, Function<SequencedCollection<INPUT_C>, Object2IntMap<NormalizedSimpleStack>> toIngredientC, @Nullable Hash.Strategy<? super OUTPUT> hashStrategy, TriPredicate<IMappingCollector<NormalizedSimpleStack, Long>, OUTPUT, Object2IntMap<NormalizedSimpleStack>> conversionAdder) {
        final class InputDetails<INPUT_A, INPUT_B, INPUT_C>
        extends Record {
            private final SequencedCollection<INPUT_A> aInputs;
            private final SequencedCollection<INPUT_B> bInputs;
            private final SequencedCollection<INPUT_C> cInputs;

            InputDetails() {
                this((SequencedCollection<INPUT_A>)new ReferenceLinkedOpenHashSet(), (SequencedCollection<INPUT_B>)new ReferenceLinkedOpenHashSet(), (SequencedCollection<INPUT_C>)new ReferenceLinkedOpenHashSet());
            }

            InputDetails(SequencedCollection<INPUT_A> aInputs, SequencedCollection<INPUT_B> bInputs, SequencedCollection<INPUT_C> cInputs) {
                this.aInputs = aInputs;
                this.bInputs = bInputs;
                this.cInputs = cInputs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{InputDetails.class, "aInputs;bInputs;cInputs", "aInputs", "bInputs", "cInputs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InputDetails.class, "aInputs;bInputs;cInputs", "aInputs", "bInputs", "cInputs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InputDetails.class, "aInputs;bInputs;cInputs", "aInputs", "bInputs", "cInputs"}, this, o);
            }

            public SequencedCollection<INPUT_A> aInputs() {
                return this.aInputs;
            }

            public SequencedCollection<INPUT_B> bInputs() {
                return this.bInputs;
            }

            public SequencedCollection<INPUT_C> cInputs() {
                return this.cInputs;
            }
        }
        HashMap<Object, InputDetails> reverseLookup = hashStrategy == null ? new HashMap<Object, InputDetails>() : new Object2ObjectOpenCustomHashMap(hashStrategy);
        List<INPUT_A> aRepresentations = inputA.getRepresentations();
        List<INPUT_B> bRepresentations = inputB.getRepresentations();
        List<INPUT_C> cRepresentations = inputC.getRepresentations();
        for (INPUT_A aRepresentation : aRepresentations) {
            for (INPUT_B bRepresentation : bRepresentations) {
                for (INPUT_C cRepresentation : cRepresentations) {
                    Object output = recipe.apply(aRepresentation, bRepresentation, cRepresentation);
                    if (emptyChecker.test(output)) continue;
                    InputDetails details = reverseLookup.computeIfAbsent(output, k -> new InputDetails());
                    details.aInputs.add(aRepresentation);
                    details.bInputs.add(bRepresentation);
                    details.cInputs.add(cRepresentation);
                }
            }
        }
        boolean handled = false;
        for (Map.Entry entry : reverseLookup.entrySet()) {
            InputDetails details = (InputDetails)entry.getValue();
            handled |= conversionAdder.test(mapper, entry.getKey(), TypedMekanismRecipeMapper.forIngredients(toIngredientA.apply(details.aInputs()), toIngredientB.apply(details.bInputs()), toIngredientC.apply(details.cInputs())));
        }
        return handled;
    }

    protected static Object2IntMap<NormalizedSimpleStack> forIngredients(Object2IntMap<NormalizedSimpleStack> a, NormalizedSimpleStack b, int bAmount) {
        if (a.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntArrayMap inputs = new Object2IntArrayMap(a);
        inputs.mergeInt((Object)b, bAmount, MERGE);
        return inputs;
    }

    protected static Object2IntMap<NormalizedSimpleStack> forIngredients(Object2IntMap<NormalizedSimpleStack> a, Object2IntMap<NormalizedSimpleStack> b, int scaleB) {
        if (a.isEmpty() || b.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        return TypedMekanismRecipeMapper.insertScaled((Object2IntMap<NormalizedSimpleStack>)new Object2IntArrayMap(a), b, scaleB);
    }

    protected static Object2IntMap<NormalizedSimpleStack> insertScaled(Object2IntMap<NormalizedSimpleStack> resultMap, Object2IntMap<NormalizedSimpleStack> inputs, int scale) {
        boolean hasValidInput = false;
        ObjectIterator iterator = Object2IntMaps.fastIterator(inputs);
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            try {
                resultMap.mergeInt((Object)((NormalizedSimpleStack)entry.getKey()), Math.multiplyExact(entry.getIntValue(), scale), MERGE);
                hasValidInput = true;
            }
            catch (ArithmeticException arithmeticException) {}
        }
        if (!hasValidInput) {
            return Object2IntMaps.emptyMap();
        }
        return resultMap;
    }

    @SafeVarargs
    protected static Object2IntMap<NormalizedSimpleStack> forIngredients(Object2IntMap<NormalizedSimpleStack> ... ingredients) {
        Object2IntArrayMap inputs = new Object2IntArrayMap(ingredients.length);
        for (Object2IntMap<NormalizedSimpleStack> ingredient : ingredients) {
            if (ingredient.isEmpty()) {
                return Object2IntMaps.emptyMap();
            }
            TypedMekanismRecipeMapper.insertScaled((Object2IntMap<NormalizedSimpleStack>)inputs, ingredient, 1);
        }
        return inputs;
    }

    protected record MekFakeGroupHelper(INSSFakeGroupManager manager) {
        public Object2IntMap<NormalizedSimpleStack> forIngredients(InputIngredient<?> ... ingredients) {
            Object2IntArrayMap inputs = new Object2IntArrayMap(ingredients.length);
            InputIngredient<?>[] inputIngredientArray = ingredients;
            int n = inputIngredientArray.length;
            for (int i = 0; i < n; ++i) {
                Object2IntMap<NormalizedSimpleStack> representations;
                InputIngredient<?> ingredient;
                InputIngredient<?> inputIngredient = ingredient = inputIngredientArray[i];
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStackIngredient.class, FluidStackIngredient.class, ChemicalStackIngredient.class}, inputIngredient, n2)) {
                    case 0: {
                        ItemStackIngredient itemIngredient = (ItemStackIngredient)inputIngredient;
                        Object2IntMap<NormalizedSimpleStack> object2IntMap = this.forIngredient(itemIngredient);
                        break;
                    }
                    case 1: {
                        FluidStackIngredient fluidIngredient = (FluidStackIngredient)inputIngredient;
                        Object2IntMap<NormalizedSimpleStack> object2IntMap = this.forIngredient(fluidIngredient);
                        break;
                    }
                    case 2: {
                        ChemicalStackIngredient chemicalIngredient = (ChemicalStackIngredient)inputIngredient;
                        Object2IntMap<NormalizedSimpleStack> object2IntMap = this.forIngredient(chemicalIngredient);
                        break;
                    }
                    default: {
                        Object2IntMap<NormalizedSimpleStack> object2IntMap = representations = Object2IntMaps.emptyMap();
                    }
                }
                if (representations.isEmpty()) {
                    return Object2IntMaps.emptyMap();
                }
                TypedMekanismRecipeMapper.insertScaled((Object2IntMap<NormalizedSimpleStack>)inputs, representations, 1);
            }
            return inputs;
        }

        public Object2IntMap<NormalizedSimpleStack> forIngredient(ItemStackIngredient ingredient) {
            return this.forItems(ingredient.getRepresentations());
        }

        public Object2IntMap<NormalizedSimpleStack> forItems(SequencedCollection<ItemStack> representations) {
            return this.forIngredient(representations, NSSItem::createItem, ItemStack::getCount);
        }

        public Object2IntMap<NormalizedSimpleStack> forIngredient(FluidStackIngredient ingredient) {
            return this.forFluids(ingredient.getRepresentations());
        }

        public Object2IntMap<NormalizedSimpleStack> forFluids(SequencedCollection<FluidStack> representations) {
            return this.forIngredient(representations, NSSFluid::createFluid, FluidStack::getAmount);
        }

        public Object2IntMap<NormalizedSimpleStack> forIngredient(ChemicalStackIngredient ingredient) {
            return this.forChemicals(ingredient.getRepresentations());
        }

        public Object2IntMap<NormalizedSimpleStack> forChemicals(SequencedCollection<ChemicalStack> representations) {
            for (ChemicalStack representation : representations) {
                if (representation.getAmount() <= Integer.MAX_VALUE) continue;
                return Object2IntMaps.emptyMap();
            }
            return this.forIngredient(representations, NSSChemical::createChemical, stack -> (int)stack.getAmount());
        }

        private <STACK> Object2IntMap<NormalizedSimpleStack> forIngredient(SequencedCollection<STACK> representations, Function<STACK, NormalizedSimpleStack> nssCreator, ToIntFunction<STACK> stackSize) {
            int size = representations.size();
            if (size == 0) {
                return Object2IntMaps.emptyMap();
            }
            if (size == 1) {
                STACK stack = representations.getFirst();
                return Object2IntMaps.singleton((Object)nssCreator.apply(stack), (int)stackSize.applyAsInt(stack));
            }
            Object2IntOpenHashMap stacks = new Object2IntOpenHashMap(size);
            for (Object representation : representations) {
                stacks.mergeInt((Object)nssCreator.apply(representation), stackSize.applyAsInt(representation), MERGE);
            }
            INSSFakeGroupManager.FakeGroupData fakeGroup = this.manager.getOrCreateFakeGroupDirect((Object2IntMap)stacks, true);
            return Object2IntMaps.singleton((Object)fakeGroup.dummy(), (int)1);
        }
    }
}

