/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.basic.BasicChemicalDissolutionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Dissolution")
public class ChemicalDissolutionRecipeManager
extends MekanismRecipeManager<SingleItemChemicalRecipeInput, ChemicalDissolutionRecipe> {
    public static final ChemicalDissolutionRecipeManager INSTANCE = new ChemicalDissolutionRecipeManager();

    private ChemicalDissolutionRecipeManager() {
        super(MekanismRecipeType.DISSOLUTION);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack output, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, output, perTickUsage));
    }

    public final BasicChemicalDissolutionRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack output, boolean perTickUsage) {
        return new BasicChemicalDissolutionRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, this.getAndValidateNotEmpty(output), perTickUsage);
    }

    @Override
    protected String describeOutputs(ChemicalDissolutionRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), stack -> {
            CrTChemicalStack output = new CrTChemicalStack((ChemicalStack)stack);
            return ((Object)output).toString();
        });
    }
}

