/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@ParametersAreNotNullByDefault
public record ModuleHydraulicPropulsionUnit(JumpBoost jumpBoost, StepAssist stepAssist) implements ICustomModule<ModuleHydraulicPropulsionUnit>
{
    public static final ResourceLocation JUMP_BOOST = Mekanism.rl("jump_boost");
    public static final ResourceLocation STEP_ASSIST = Mekanism.rl("step_assist");

    public ModuleHydraulicPropulsionUnit(IModule<ModuleHydraulicPropulsionUnit> module) {
        this((JumpBoost)module.getConfigOrThrow(JUMP_BOOST).get(), (StepAssist)module.getConfigOrThrow(STEP_ASSIST).get());
    }

    public float getBoost() {
        return this.jumpBoost.getBoost();
    }

    public float getStepHeight() {
        return this.stepAssist.getHeight();
    }

    @NothingNullByDefault
    public static enum JumpBoost implements IHasTextComponent,
    StringRepresentable
    {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(3.0f),
        ULTRA(5.0f);

        public static final Codec<JumpBoost> CODEC;
        public static final IntFunction<JumpBoost> BY_ID;
        public static final StreamCodec<ByteBuf, JumpBoost> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final float boost;
        private final Component label;

        private JumpBoost(float boost) {
            this.boost = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(JumpBoost::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])JumpBoost.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    @NothingNullByDefault
    public static enum StepAssist implements IHasTextComponent,
    StringRepresentable
    {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(1.5f),
        ULTRA(2.0f);

        public static final Codec<StepAssist> CODEC;
        public static final IntFunction<StepAssist> BY_ID;
        public static final StreamCodec<ByteBuf, StepAssist> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final float height;
        private final Component label;

        private StepAssist(float height) {
            this.height = height;
            this.label = TextComponentUtil.getString(Float.toString(height));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getHeight() {
            return this.height;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(StepAssist::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])StepAssist.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

