/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class FluidTankWrapper
implements IExtendedFluidTank {
    private final IChemicalTank chemicalTank;
    private final IExtendedFluidTank internal;
    private final MergedTank mergedTank;

    public FluidTankWrapper(MergedTank mergedTank, IExtendedFluidTank internal, IChemicalTank chemicalTank) {
        this.mergedTank = mergedTank;
        this.internal = internal;
        this.chemicalTank = chemicalTank;
    }

    public MergedTank getMergedTank() {
        return this.mergedTank;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.internal.setStack(stack);
    }

    @Override
    public void setStackUnchecked(FluidStack stack) {
        this.internal.setStackUnchecked(stack);
    }

    private boolean canInsert() {
        return this.chemicalTank.isEmpty();
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        return this.canInsert() ? this.internal.insert(stack, action, automationType) : stack;
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        return this.internal.extract(amount, action, automationType);
    }

    @Override
    public void onContentsChanged() {
        this.internal.onContentsChanged();
    }

    @Override
    public int setStackSize(int amount, Action action) {
        return this.internal.setStackSize(amount, action);
    }

    @Override
    public int growStack(int amount, Action action) {
        return this.internal.growStack(amount, action);
    }

    @Override
    public int shrinkStack(int amount, Action action) {
        return this.internal.shrinkStack(amount, action);
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public void setEmpty() {
        this.internal.setEmpty();
    }

    @Override
    public boolean isFluidEqual(FluidStack other) {
        return this.internal.isFluidEqual(other);
    }

    @Override
    public int getNeeded() {
        return this.internal.getNeeded();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.internal.serializeNBT(provider);
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.internal.deserializeNBT(provider, nbt);
    }

    @NotNull
    public FluidStack getFluid() {
        return this.internal.getFluid();
    }

    @Override
    public int getFluidAmount() {
        return this.internal.getFluidAmount();
    }

    public int getCapacity() {
        return this.internal.getCapacity();
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.internal.isFluidValid(stack);
    }
}

