/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.function.UnaryOperator;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockQIOComponent<TILE extends TileEntityQIOComponent, BLOCK extends BlockTypeTile<TILE>>
extends BlockTile.BlockTileModel<TILE, BLOCK> {
    public BlockQIOComponent(BLOCK type, UnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        super(type, propertiesModifier);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        ItemStack stack;
        FrequencyAware frequencyAware;
        AttributeStateActive attribute;
        BlockState state = super.getStateForPlacement(context);
        if (state != null && (attribute = Attribute.get(state, AttributeStateActive.class)) != null && (frequencyAware = (FrequencyAware)(stack = context.getItemInHand()).get(MekanismDataComponents.QIO_FREQUENCY)) != null) {
            state = context.getLevel().isClientSide ? attribute.setActive(state, frequencyAware.identity().isPresent()) : attribute.setActive(state, frequencyAware.frequency().isPresent());
        }
        return state;
    }
}

