/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base.holiday;

import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.common.Mekanism;
import mekanism.common.base.holiday.AprilFools;
import mekanism.common.base.holiday.Holiday;
import mekanism.common.base.holiday.HolidayManager;
import mekanism.common.base.holiday.May4;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="mekanism", value={Dist.CLIENT})
public final class ClientHolidayInfo {
    private static final ResourceLocation MINER_SCREEN = Mekanism.rl("block/models/digital_miner_screen_");
    private static final Predicate<ResourceLocation> IS_HELLO_SCREEN = s -> s.getPath().contains("screen_hello");
    private static final Predicate<ResourceLocation> IS_CMD_SCREEN = s -> s.getPath().contains("screen_cmd");
    private static final Predicate<ResourceLocation> IS_BLANK_SCREEN = s -> s.getPath().contains("screen_blank");
    private static Map<Holiday, QuadTransformation> HOLIDAY_MINER_TRANSFORMS = Collections.emptyMap();

    private ClientHolidayInfo() {
    }

    @SubscribeEvent
    public static void onStitch(TextureAtlasStitchedEvent event) {
        TextureAtlas atlas = event.getAtlas();
        if (!atlas.location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        HOLIDAY_MINER_TRANSFORMS = Map.of(AprilFools.INSTANCE, QuadTransformation.list(QuadTransformation.TextureFilteredTransformation.of(ClientHolidayInfo.minerTexture(atlas, "afd_sad"), IS_HELLO_SCREEN.or(IS_CMD_SCREEN)), QuadTransformation.TextureFilteredTransformation.of(ClientHolidayInfo.minerTexture(atlas, "afd_text"), IS_BLANK_SCREEN)), May4.INSTANCE, QuadTransformation.TextureFilteredTransformation.of(ClientHolidayInfo.minerTexture(atlas, "may4th"), IS_HELLO_SCREEN));
    }

    private static QuadTransformation minerTexture(TextureAtlas atlas, String screen) {
        return ClientHolidayInfo.texture(atlas, MINER_SCREEN.withSuffix(screen));
    }

    private static QuadTransformation texture(TextureAtlas atlas, ResourceLocation location) {
        return QuadTransformation.texture(atlas.getSprite(location));
    }

    @Nullable
    public static QuadTransformation getMinerTransform() {
        if (HolidayManager.areHolidaysEnabled()) {
            for (Map.Entry<Holiday, QuadTransformation> entry : HOLIDAY_MINER_TRANSFORMS.entrySet()) {
                if (!entry.getKey().isToday()) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

