/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.heat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.OptionalDouble;
import mekanism.common.network.PacketUtils;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public record HeatCapacitorData(OptionalDouble heat, double capacity) {
    public static final Codec<HeatCapacitorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("stored").forGetter(data -> data.heat.isPresent() ? Optional.of(data.heat.getAsDouble()) : Optional.empty()), (App)Codec.DOUBLE.fieldOf("heat_capacity").forGetter(HeatCapacitorData::capacity)).apply((Applicative)instance, (heat, capacity) -> new HeatCapacitorData(heat.map(OptionalDouble::of).orElseGet(OptionalDouble::empty), (double)capacity)));
    public static final StreamCodec<ByteBuf, HeatCapacitorData> STREAM_CODEC = StreamCodec.composite(PacketUtils.OPTIONAL_DOUBLE_STREAM_CODEC, HeatCapacitorData::heat, (StreamCodec)ByteBufCodecs.DOUBLE, HeatCapacitorData::capacity, HeatCapacitorData::new);

    public HeatCapacitorData(double heat, double capacity) {
        this(OptionalDouble.of(heat), capacity);
    }

    public HeatCapacitorData(double capacity) {
        this(OptionalDouble.empty(), capacity);
    }

    public HeatCapacitorData withHeat(double heat) {
        if (Mth.equal((double)this.heatOrAmbient(), (double)heat)) {
            return this;
        }
        return new HeatCapacitorData(heat, this.capacity);
    }

    public double temperature() {
        if (this.heat.isPresent()) {
            return this.heat.getAsDouble() / this.capacity;
        }
        return 300.0;
    }

    public double heatOrAmbient() {
        if (this.heat.isPresent()) {
            return this.heat.getAsDouble();
        }
        return 300.0 * this.capacity;
    }
}

