/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public record AttachedFluids(List<FluidStack> containers) implements IAttachedContainers<FluidStack, AttachedFluids>
{
    public static final AttachedFluids EMPTY = new AttachedFluids(Collections.emptyList());
    public static final Codec<AttachedFluids> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializerHelper.LENIENT_OPTIONAL_FLUID_CODEC.listOf().fieldOf("fluid_tanks").forGetter(AttachedFluids::containers)).apply((Applicative)instance, AttachedFluids::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttachedFluids> STREAM_CODEC = FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(AttachedFluids::new, AttachedFluids::containers);

    public AttachedFluids {
        containers = Collections.unmodifiableList(containers);
    }

    public static AttachedFluids create(int containers) {
        return new AttachedFluids((List<FluidStack>)NonNullList.withSize((int)containers, (Object)FluidStack.EMPTY));
    }

    @Override
    public FluidStack getEmptyStack() {
        return FluidStack.EMPTY;
    }

    @Override
    public AttachedFluids create(List<FluidStack> containers) {
        return new AttachedFluids(containers);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        List<FluidStack> otherContainers = ((AttachedFluids)o).containers;
        if (this.containers.size() != otherContainers.size()) {
            return false;
        }
        for (int i = 0; i < this.containers.size(); ++i) {
            if (FluidStack.matches((FluidStack)this.containers.get(i), (FluidStack)otherContainers.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (FluidStack stack : this.containers) {
            hash = hash * 31 + FluidStack.hashFluidAndComponents((FluidStack)stack);
        }
        return hash;
    }
}

