/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.qio.DriveMetadata;
import mekanism.common.item.interfaces.IColoredItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record FrequencyAware<FREQ extends Frequency>(Optional<Frequency.FrequencyIdentity> identity, Optional<FREQ> frequency) {
    public static final FrequencyAware<?> NONE = new FrequencyAware(Optional.empty(), Optional.empty());
    public static final StreamCodec<ByteBuf, DriveMetadata> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, DriveMetadata::count, (StreamCodec)ByteBufCodecs.VAR_INT, DriveMetadata::types, DriveMetadata::new);

    public FrequencyAware(@NotNull FREQ freq) {
        this(Optional.of(((Frequency)freq).getIdentity()), Optional.of(freq));
    }

    public static <FREQ extends Frequency> FrequencyAware<FREQ> none() {
        return NONE;
    }

    public static <FREQ extends Frequency> Codec<FrequencyAware<FREQ>> codec(FrequencyType<FREQ> frequencyType) {
        return RecordCodecBuilder.create(instance -> instance.group((App)frequencyType.getIdentitySerializer().codec().optionalFieldOf("identity").forGetter(FrequencyAware::identity)).apply((Applicative)instance, identity -> {
            Object frequency = null;
            if (identity.isPresent() && EffectiveSide.get().isServer()) {
                frequency = frequencyType.getManager((Frequency.FrequencyIdentity)identity.get(), ((Frequency.FrequencyIdentity)identity.get()).ownerUUID()).getFrequency(((Frequency.FrequencyIdentity)identity.get()).key());
            }
            return new FrequencyAware<Object>((Optional<Frequency.FrequencyIdentity>)identity, Optional.ofNullable(frequency));
        }));
    }

    public static <FREQ extends Frequency> StreamCodec<ByteBuf, FrequencyAware<FREQ>> streamCodec(FrequencyType<FREQ> frequencyType) {
        return ByteBufCodecs.optional(frequencyType.getIdentitySerializer().streamCodec()).map(identity -> {
            Object frequency = null;
            if (identity.isPresent() && EffectiveSide.get().isServer()) {
                frequency = frequencyType.getManager((Frequency.FrequencyIdentity)identity.get(), ((Frequency.FrequencyIdentity)identity.get()).ownerUUID()).getFrequency(((Frequency.FrequencyIdentity)identity.get()).key());
            }
            return new FrequencyAware<Object>((Optional<Frequency.FrequencyIdentity>)identity, Optional.ofNullable(frequency));
        }, FrequencyAware::identity);
    }

    @Nullable
    public UUID getOwner() {
        return this.identity.map(Frequency.FrequencyIdentity::ownerUUID).orElse(null);
    }

    @Nullable
    public FREQ getFrequency(ItemStack stack, DataComponentType<FrequencyAware<FREQ>> type) {
        SecurityFrequency security;
        UUID ownerUUID;
        Frequency frequency = this.frequency().orElse(null);
        if (frequency != null && frequency.getSecurity() == SecurityMode.TRUSTED && EffectiveSide.get().isServer() && (ownerUUID = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack)) != null && !frequency.ownerMatches(ownerUUID) && (security = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(frequency.getOwner())) != null && !security.isTrusted(ownerUUID)) {
            stack.remove(type);
            if (stack.getItem() instanceof IColoredItem) {
                stack.remove(MekanismDataComponents.COLOR);
            }
        }
        return (FREQ)frequency;
    }

    public static <FREQ extends Frequency> FrequencyAware<FREQ> create(FrequencyType<FREQ> frequencyType, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyManager<FREQ> manager;
        Frequency freq = null;
        if (!Objects.equals(data.ownerUUID(), player) && SecurityUtils.get().isTrusted(data.securityMode(), data.ownerUUID(), player) && (freq = (manager = frequencyType.getManager(data, data.ownerUUID())).getFrequency(data.key())) == null) {
            data = new Frequency.FrequencyIdentity(data.key(), data.securityMode(), player);
        }
        if (freq == null) {
            manager = frequencyType.getManager(data, player);
            freq = manager.getOrCreateFrequency(data, player);
        }
        return new FrequencyAware<Frequency>(Optional.of(freq.getIdentity()), Optional.of(freq));
    }
}

