/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderDimensionalStabilizer
extends MekanismTileEntityRenderer<TileEntityDimensionalStabilizer> {
    private static final MekanismRenderer.LazyModel model = new MekanismRenderer.LazyModel(() -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.whiteIcon).bounds(0.0f, 1.0f).setSideRender(direction -> direction.getAxis().isHorizontal()));
    private static final int[] colors = new int[EnumUtils.DIRECTIONS.length];

    public static void resetCachedVisuals() {
        model.reset();
    }

    public RenderDimensionalStabilizer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityDimensionalStabilizer stabilizer, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        boolean[][][] allRenderSides = new boolean[5][5][5];
        for (int x = 0; x < allRenderSides.length; ++x) {
            boolean[][] rowRenderSides = allRenderSides[x];
            for (int z = 0; z < rowRenderSides.length; ++z) {
                boolean[] previousRenderSides;
                if (!stabilizer.isChunkLoadingAt(x, z)) continue;
                boolean[] renderSides = rowRenderSides[z];
                Arrays.fill(renderSides, true);
                if (x > 0 && (previousRenderSides = allRenderSides[x - 1][z])[Direction.EAST.get2DDataValue()]) {
                    renderSides[Direction.WEST.get2DDataValue()] = false;
                    previousRenderSides[Direction.EAST.get2DDataValue()] = false;
                }
                if (z <= 0 || !(previousRenderSides = rowRenderSides[z - 1])[Direction.SOUTH.get2DDataValue()]) continue;
                renderSides[Direction.NORTH.get2DDataValue()] = false;
                previousRenderSides[Direction.SOUTH.get2DDataValue()] = false;
            }
        }
        Level level = stabilizer.getLevel();
        int minY = level.getMinBuildHeight();
        int height = level.getMaxBuildHeight() - minY;
        BlockPos pos = stabilizer.getBlockPos();
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        MekanismRenderer.Model3D model = RenderDimensionalStabilizer.model.get();
        VertexConsumer buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
        Camera camera = this.getCamera();
        for (RenderPiece piece : this.calculateRenderPieces(allRenderSides)) {
            model.setSideRender(Direction.NORTH, piece.renderNorth).setSideRender(Direction.EAST, piece.renderEast).setSideRender(Direction.SOUTH, piece.renderSouth).setSideRender(Direction.WEST, piece.renderWest);
            int xChunkOffset = piece.x - 2;
            int zChunkOffset = piece.z - 2;
            ChunkPos startChunk = new ChunkPos(chunkX + xChunkOffset, chunkZ + zChunkOffset);
            ChunkPos endChunk = new ChunkPos(startChunk.x + piece.xLength - 1, startChunk.z + piece.zLength - 1);
            double xShift = 0.01;
            double zShift = 0.01;
            float xScaleShift = 0.02f;
            float zScaleShift = 0.02f;
            if (piece.renderEast && piece.renderWest && !piece.renderNorth) {
                zShift = -0.01;
                zScaleShift = piece.renderSouth ? 0.0f : -0.02f;
            } else if (piece.renderNorth && !piece.renderSouth) {
                zScaleShift = 0.0f;
            } else if (piece.renderNorth && piece.renderWest && !piece.renderEast) {
                xScaleShift = 0.0f;
            } else if (piece.renderNorth && !piece.renderWest) {
                xShift = -0.01;
                xScaleShift = piece.renderEast ? 0.0f : -0.02f;
            } else if (piece.renderSouth && piece.renderEast != piece.renderWest) {
                zShift = -0.01;
                zScaleShift = 0.0f;
            }
            matrix.pushPose();
            matrix.translate((double)(startChunk.getMinBlockX() - pos.getX()) + xShift, (double)(minY - pos.getY()), (double)(startChunk.getMinBlockZ() - pos.getZ()) + zShift);
            matrix.scale((float)(16 * piece.xLength) - xScaleShift, (float)height, (float)(16 * piece.zLength) - zScaleShift);
            RenderResizableCuboid.FaceDisplay faceDisplay = this.isInsideBounds(startChunk.getMinBlockX(), Double.NEGATIVE_INFINITY, startChunk.getMinBlockZ(), endChunk.getMaxBlockX() + 1, Double.POSITIVE_INFINITY, endChunk.getMaxBlockZ() + 1) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.BOTH;
            MekanismRenderer.renderObject(model, matrix, buffer, colors, 0xF000F0, overlayLight, faceDisplay, camera);
            matrix.popPose();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "dimensionalStabilizer";
    }

    public boolean shouldRenderOffScreen(TileEntityDimensionalStabilizer tile) {
        return true;
    }

    public boolean shouldRender(TileEntityDimensionalStabilizer tile, Vec3 camera) {
        return tile.isClientRendering() && tile.canDisplayVisuals() && super.shouldRender((BlockEntity)tile, camera);
    }

    public AABB getRenderBoundingBox(TileEntityDimensionalStabilizer tile) {
        Level level = tile.getLevel();
        if (tile.isClientRendering() && tile.canDisplayVisuals() && level != null) {
            int chunkX = SectionPos.blockToSectionCoord((int)tile.getBlockPos().getX());
            int chunkZ = SectionPos.blockToSectionCoord((int)tile.getBlockPos().getZ());
            ChunkPos minChunk = new ChunkPos(chunkX - 2, chunkZ - 2);
            ChunkPos maxChunk = new ChunkPos(chunkX + 2, chunkZ + 2);
            return new AABB((double)minChunk.getMinBlockX(), (double)level.getMinBuildHeight(), (double)minChunk.getMinBlockZ(), (double)(maxChunk.getMaxBlockX() + 1), (double)level.getMaxBuildHeight(), (double)(maxChunk.getMaxBlockZ() + 1));
        }
        return super.getRenderBoundingBox((BlockEntity)tile);
    }

    private List<RenderPiece> calculateRenderPieces(boolean[][][] allRenderSides) {
        record MinimalRowPieceData(int x, boolean renderEast, boolean renderWest) {
        }
        record MinimalColumnPieceData(int z, int zLength, boolean renderNorth, boolean renderSouth) {
        }
        HashMap<MinimalColumnPieceData, List> columnData = new HashMap<MinimalColumnPieceData, List>();
        for (int x = 0; x < allRenderSides.length; ++x) {
            int zLength;
            boolean[][] rowRenderSides = allRenderSides[x];
            for (int z = 0; z < rowRenderSides.length; z += zLength) {
                boolean[] nextColumnRenderSides;
                zLength = 1;
                boolean[] renderSides = rowRenderSides[z];
                if (!renderSides[4]) continue;
                boolean renderNorth = renderSides[Direction.NORTH.get2DDataValue()];
                boolean renderSouth = renderSides[Direction.SOUTH.get2DDataValue()];
                boolean renderEast = renderSides[Direction.EAST.get2DDataValue()];
                boolean renderWest = renderSides[Direction.WEST.get2DDataValue()];
                while (!renderSouth && z + zLength < rowRenderSides.length && renderEast == (nextColumnRenderSides = rowRenderSides[z + zLength])[Direction.EAST.get2DDataValue()] && renderWest == nextColumnRenderSides[Direction.WEST.get2DDataValue()]) {
                    ++zLength;
                    renderSouth = nextColumnRenderSides[Direction.SOUTH.get2DDataValue()];
                }
                columnData.computeIfAbsent(new MinimalColumnPieceData(z, zLength, renderNorth, renderSouth), piece -> new ArrayList(5)).add(new MinimalRowPieceData(x, renderEast, renderWest));
            }
        }
        ArrayList<RenderPiece> pieces = new ArrayList<RenderPiece>();
        for (Map.Entry entry : columnData.entrySet()) {
            int xLength;
            MinimalColumnPieceData minimalColumnPiece = (MinimalColumnPieceData)entry.getKey();
            List rows = (List)entry.getValue();
            for (int row = 0; row < rows.size(); row += xLength) {
                xLength = 1;
                MinimalRowPieceData minimalRowPiece = (MinimalRowPieceData)rows.get(row);
                boolean renderEast = minimalRowPiece.renderEast;
                while (!renderEast && row + xLength < rows.size()) {
                    MinimalRowPieceData nextRowPiece = (MinimalRowPieceData)rows.get(row + xLength);
                    if (minimalRowPiece.x + xLength != nextRowPiece.x) break;
                    ++xLength;
                    renderEast = nextRowPiece.renderEast;
                }
                pieces.add(new RenderPiece(minimalRowPiece.x, xLength, minimalColumnPiece.z, minimalColumnPiece.zLength, minimalColumnPiece.renderNorth, minimalColumnPiece.renderSouth, renderEast, minimalRowPiece.renderWest));
            }
        }
        return pieces;
    }

    static {
        int n = MekanismRenderer.getColorARGB(0xFFFFFF, 0.82f);
        RenderDimensionalStabilizer.colors[Direction.NORTH.ordinal()] = n;
        RenderDimensionalStabilizer.colors[Direction.SOUTH.ordinal()] = n;
        int n2 = MekanismRenderer.getColorARGB(0xFFFFFF, 0.78f);
        RenderDimensionalStabilizer.colors[Direction.WEST.ordinal()] = n2;
        RenderDimensionalStabilizer.colors[Direction.EAST.ordinal()] = n2;
    }

    private record RenderPiece(int x, int xLength, int z, int zLength, boolean renderNorth, boolean renderSouth, boolean renderEast, boolean renderWest) {
    }
}

