/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.common.lib.Color;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface QuadTransformation {
    public static final Direction[][] ROTATION_MATRIX = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN}, {Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.UP, Direction.UP, Direction.UP}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.WEST, Direction.WEST, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}, {Direction.EAST, Direction.EAST, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}};
    public static final QuadTransformation identity = q -> false;
    public static final QuadTransformation fullbright = QuadTransformation.packedLight(0xF000F0);
    public static final QuadTransformation filtered_fullbright = TextureFilteredTransformation.of(fullbright, rl -> rl.getPath().contains("led"));

    public static QuadTransformation color(Color color) {
        return new ColorTransformation(color);
    }

    public static QuadTransformation light(int light) {
        return new LightTransformation(light, light);
    }

    public static QuadTransformation packedLight(int light) {
        return new LightTransformation(LightTexture.block((int)light), LightTexture.sky((int)light));
    }

    public static QuadTransformation ambientShade(boolean ambientOcclusion, boolean shade) {
        return new AmbientShadeTransformation(ambientOcclusion, shade);
    }

    public static QuadTransformation translate(float xTranslation, float yTranslation, float zTranslation) {
        return QuadTransformation.translate(new Vector3f(xTranslation, yTranslation, zTranslation));
    }

    public static QuadTransformation translate(Vector3f translation) {
        return new TranslationTransformation(translation);
    }

    public static QuadTransformation rotate(Direction side) {
        if (side == null) {
            return identity;
        }
        return switch (side) {
            case Direction.UP -> QuadTransformation.rotate(90.0, 0.0, 0.0);
            case Direction.DOWN -> QuadTransformation.rotate(-90.0, 0.0, 0.0);
            case Direction.WEST -> QuadTransformation.rotate(0.0, 90.0, 0.0);
            case Direction.EAST -> QuadTransformation.rotate(0.0, -90.0, 0.0);
            case Direction.SOUTH -> QuadTransformation.rotate(0.0, 180.0, 0.0);
            default -> identity;
        };
    }

    public static QuadTransformation rotateY(double degrees) {
        return QuadTransformation.rotate(0.0, degrees, 0.0);
    }

    public static QuadTransformation rotate(double rotationX, double rotationY, double rotationZ) {
        return QuadTransformation.rotate(new Quaternion(rotationX, rotationY, rotationZ, true));
    }

    public static QuadTransformation rotate(Quaternion quat) {
        return new RotationTransformation(quat);
    }

    public static QuadTransformation sideRotate(Direction side) {
        return new SideTransformation(side);
    }

    public static QuadTransformation texture(TextureAtlasSprite texture) {
        return new TextureTransformation(texture);
    }

    public static QuadTransformation uvShift(float uShift, float vShift) {
        return new UVTransformation(uShift, vShift);
    }

    public static QuadTransformation list(QuadTransformation ... transforms) {
        return TransformationList.of(transforms);
    }

    public boolean transform(Quad var1);

    default public QuadTransformation and(QuadTransformation other) {
        return QuadTransformation.list(this, other);
    }

    public static class ColorTransformation
    implements QuadTransformation {
        private final Color color;

        protected ColorTransformation(Color color) {
            this.color = color;
        }

        @Override
        public boolean transform(Quad quad) {
            for (Vertex v : quad.getVertices()) {
                v.color(this.color);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColorTransformation)) return false;
            ColorTransformation other = (ColorTransformation)o;
            if (!this.color.equals(other.color)) return false;
            return true;
        }

        public int hashCode() {
            return this.color.hashCode();
        }
    }

    public static class LightTransformation
    implements QuadTransformation {
        private final int lightU;
        private final int lightV;

        public LightTransformation(int lightU, int lightV) {
            this.lightU = lightU;
            this.lightV = lightV;
        }

        @Override
        public boolean transform(Quad quad) {
            for (Vertex v : quad.getVertices()) {
                v.light(this.lightU, this.lightV);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LightTransformation)) return false;
            LightTransformation other = (LightTransformation)o;
            if (this.lightU != other.lightU) return false;
            if (this.lightV != other.lightV) return false;
            return true;
        }

        public int hashCode() {
            int result = this.lightU;
            result = 31 * result + this.lightV;
            return result;
        }
    }

    public static class AmbientShadeTransformation
    implements QuadTransformation {
        private final boolean ambientOcclusion;
        private final boolean shade;

        public AmbientShadeTransformation(boolean ambientOcclusion, boolean shade) {
            this.ambientOcclusion = ambientOcclusion;
            this.shade = shade;
        }

        @Override
        public boolean transform(Quad quad) {
            quad.setHasAmbientOcclusion(this.ambientOcclusion);
            quad.setShade(this.shade);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmbientShadeTransformation)) return false;
            AmbientShadeTransformation other = (AmbientShadeTransformation)o;
            if (this.ambientOcclusion != other.ambientOcclusion) return false;
            if (this.shade != other.shade) return false;
            return true;
        }

        public int hashCode() {
            return 31 * Boolean.hashCode(this.ambientOcclusion) + Boolean.hashCode(this.shade);
        }
    }

    public static class TranslationTransformation
    implements QuadTransformation {
        private final Vector3f translation;

        protected TranslationTransformation(Vector3f translation) {
            this.translation = translation;
        }

        @Override
        public boolean transform(Quad quad) {
            for (Vertex v : quad.getVertices()) {
                v.getPos().add((Vector3fc)this.translation);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslationTransformation)) return false;
            TranslationTransformation other = (TranslationTransformation)o;
            if (!this.translation.equals((Object)other.translation)) return false;
            return true;
        }

        public int hashCode() {
            return this.translation.hashCode();
        }
    }

    public static class RotationTransformation
    implements QuadTransformation {
        private static final double EPSILON = 10000.0;
        private final Quaternion quaternion;

        protected RotationTransformation(Quaternion quaternion) {
            this.quaternion = quaternion;
        }

        @Override
        public boolean transform(Quad quad) {
            for (Vertex v : quad.getVertices()) {
                v.pos(RotationTransformation.round(this.quaternion.rotate(v.getPosD().subtract(0.5, 0.5, 0.5)).add(0.5, 0.5, 0.5)));
                v.normal(RotationTransformation.round(this.quaternion.rotate(v.getNormalD()).normalize()));
            }
            return true;
        }

        private static Vec3 round(Vec3 vec) {
            return new Vec3((double)Math.round(vec.x * 10000.0) / 10000.0, (double)Math.round(vec.y * 10000.0) / 10000.0, (double)Math.round(vec.z * 10000.0) / 10000.0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RotationTransformation)) return false;
            RotationTransformation other = (RotationTransformation)o;
            if (!this.quaternion.equals(other.quaternion)) return false;
            return true;
        }

        public int hashCode() {
            return this.quaternion.hashCode();
        }
    }

    public static class SideTransformation
    implements QuadTransformation {
        private final Direction side;

        protected SideTransformation(Direction side) {
            this.side = side;
        }

        @Override
        public boolean transform(Quad quad) {
            Direction newSide;
            if (this.side != null && (newSide = ROTATION_MATRIX[quad.getSide().ordinal()][this.side.ordinal()]) != quad.getSide()) {
                quad.setSide(newSide);
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SideTransformation)) return false;
            SideTransformation other = (SideTransformation)o;
            if (this.side != other.side) return false;
            return true;
        }

        public int hashCode() {
            return this.side == null ? -1 : this.side.hashCode();
        }
    }

    public static class TextureTransformation
    implements QuadTransformation {
        private final TextureAtlasSprite texture;

        protected TextureTransformation(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public boolean transform(Quad quad) {
            if (this.texture != null && quad.getTexture() != this.texture) {
                QuadUtils.remapUVs(quad, this.texture);
                quad.setTexture(this.texture);
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextureTransformation)) return false;
            TextureTransformation other = (TextureTransformation)o;
            if (this.texture != other.texture) return false;
            return true;
        }

        public int hashCode() {
            return this.texture == null ? -1 : this.texture.hashCode();
        }
    }

    public static class UVTransformation
    implements QuadTransformation {
        private final float uShift;
        private final float vShift;

        protected UVTransformation(float uShift, float vShift) {
            this.uShift = uShift;
            this.vShift = vShift;
        }

        @Override
        public boolean transform(Quad quad) {
            TextureAtlasSprite texture = quad.getTexture();
            float uMin = texture.getU0();
            float uMax = texture.getU1();
            float vMin = texture.getV0();
            float vMax = texture.getV1();
            float uShift = this.uShift * (uMax - uMin);
            float vShift = this.vShift * (vMax - vMin);
            for (Vertex v : quad.getVertices()) {
                v.texRaw(v.getTexU() + uShift, v.getTexV() + vShift);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UVTransformation)) return false;
            UVTransformation other = (UVTransformation)o;
            if (Float.compare(other.uShift, this.uShift) != 0) return false;
            if (Float.compare(other.vShift, this.vShift) != 0) return false;
            return true;
        }

        public int hashCode() {
            int result = Float.hashCode(this.uShift);
            result = 31 * result + Float.hashCode(this.vShift);
            return result;
        }
    }

    public static class TransformationList
    implements QuadTransformation {
        private final List<QuadTransformation> list;
        private final int hashCode;

        protected TransformationList(List<QuadTransformation> list) {
            this.list = list;
            this.hashCode = list.hashCode();
        }

        public static TransformationList of(QuadTransformation ... trans) {
            return new TransformationList(List.of(trans));
        }

        @Override
        public boolean transform(Quad quad) {
            boolean transformed = false;
            for (QuadTransformation transformation : this.list) {
                transformed |= transformation.transform(quad);
            }
            return transformed;
        }

        @Override
        public QuadTransformation and(QuadTransformation other) {
            ArrayList<QuadTransformation> newList = new ArrayList<QuadTransformation>(this.list);
            newList.add(other);
            return new TransformationList(newList);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformationList)) return false;
            TransformationList other = (TransformationList)o;
            if (!this.list.equals(other.list)) return false;
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class TextureFilteredTransformation
    implements QuadTransformation {
        private final QuadTransformation original;
        private final Predicate<ResourceLocation> verifier;

        protected TextureFilteredTransformation(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            this.original = original;
            this.verifier = verifier;
        }

        public static TextureFilteredTransformation of(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            return new TextureFilteredTransformation(original, verifier);
        }

        @Override
        public boolean transform(Quad quad) {
            return this.verifier.test(quad.getTexture().contents().name()) && this.original.transform(quad);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextureFilteredTransformation)) return false;
            TextureFilteredTransformation other = (TextureFilteredTransformation)o;
            if (!this.verifier.equals(other.verifier)) return false;
            return true;
        }

        public int hashCode() {
            int result = Objects.hashCode(this.original);
            result = 31 * result + Objects.hashCode(this.verifier);
            return result;
        }
    }
}

