/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.recipe_viewer.GhostIngredientHandler;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class EmiGhostIngredientHandler
implements EmiDragDropHandler<Screen> {
    public boolean dropStack(Screen screen, EmiIngredient ingredient, int x, int y) {
        for (EmiTarget target : this.getTargets(screen, ingredient)) {
            if (!target.handle(x, y)) continue;
            return true;
        }
        return false;
    }

    public void render(Screen screen, EmiIngredient dragged, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (EmiTarget target : this.getTargets(screen, dragged)) {
            GuiUtils.fill(graphics, target.area.getX(), target.area.getY(), target.area.getWidth(), target.area.getHeight(), -2010989773);
        }
    }

    private List<EmiTarget> getTargets(Screen screen, EmiIngredient stack) {
        if (screen instanceof GuiMekanism) {
            GuiMekanism gui = (GuiMekanism)screen;
            return GhostIngredientHandler.getTargetsTyped(gui, stack, EmiGhostIngredientHandler::getFirstSupportedStack, EmiTarget::new);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static Object getFirstSupportedStack(IRecipeViewerGhostTarget.IGhostIngredientConsumer handler, EmiIngredient ingredient) {
        for (EmiStack emiStack : ingredient.getEmiStacks()) {
            Object stack;
            Object raw = null;
            if (emiStack.getKey() instanceof Item) {
                raw = emiStack.getItemStack();
            } else {
                Object object = emiStack.getKey();
                if (object instanceof Fluid) {
                    Fluid fluid = (Fluid)object;
                    raw = new FluidStack((Holder)fluid.builtInRegistryHolder(), 1000, emiStack.getComponentChanges());
                } else if (emiStack instanceof ChemicalEmiStack) {
                    ChemicalEmiStack chemicalEmiStack = (ChemicalEmiStack)emiStack;
                    raw = chemicalEmiStack.getStack();
                }
            }
            if (raw == null || (stack = handler.supportedTarget(raw)) == null) continue;
            return stack;
        }
        return null;
    }

    private record EmiTarget(IRecipeViewerGhostTarget.IGhostIngredientConsumer handler, Object ingredient, Rect2i area) {
        public boolean handle(int x, int y) {
            if (this.area.contains(x, y)) {
                this.handler.accept(this.ingredient);
                return true;
            }
            return false;
        }
    }
}

