/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import java.util.List;
import java.util.function.Supplier;
import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.window.GuiRobitRename;
import mekanism.client.gui.element.window.GuiRobitSkinSelect;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.button.PacketEntityButtonPress;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiRobitMain
extends GuiMekanism<MainRobitContainer> {
    static final Tooltip ROBIT = TooltipUtils.create((ILangEntry)MekanismLang.ROBIT);
    static final Tooltip ROBIT_CRAFTING = TooltipUtils.create((ILangEntry)MekanismLang.ROBIT_CRAFTING);
    static final Tooltip ROBIT_INVENTORY = TooltipUtils.create((ILangEntry)MekanismLang.ROBIT_INVENTORY);
    static final Tooltip ROBIT_SMELTING = TooltipUtils.create((ILangEntry)MekanismLang.ROBIT_SMELTING);
    static final Tooltip ROBIT_REPAIR = TooltipUtils.create((ILangEntry)MekanismLang.ROBIT_REPAIR);
    private final EntityRobit robit;
    private MekanismButton renameButton;
    private MekanismButton skinButton;

    public GuiRobitMain(MainRobitContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.robit = (EntityRobit)container.getEntity();
        this.dynamicSlots = true;
    }

    private void openWindow(GuiWindow window, Supplier<? extends GuiElement> elementSupplier) {
        window.setListenerTab(elementSupplier);
        elementSupplier.get().active = false;
        this.addWindow(window);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiSecurityTab((IGuiWrapper)this, (Entity)this.robit, 120));
        this.addRenderableWidget(GuiSideHolder.create(this, this.imageWidth, 6, 106, false, false, SpecialColors.TAB_ROBIT_MENU));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 27, 16, 122, 56, () -> List.of(MekanismLang.ROBIT_GREETING.translate(this.robit.getName()), CommonComponents.EMPTY, MekanismLang.ENERGY.translate(EnergyDisplay.of(this.robit.getEnergyContainer().getEnergy())), MekanismLang.ROBIT_FOLLOWING.translate(this.robit.getFollowing()), MekanismLang.ROBIT_DROP_PICKUP.translate(this.robit.getDropPickup()), MekanismLang.ROBIT_OWNER.translate(this.robit.getOwnerName())))).clearFormat().clearSpacing().clearScale().padding(2);
        this.addRenderableWidget(new GuiHorizontalPowerBar((IGuiWrapper)this, this.robit.getEnergyContainer(), 27, 74, 120));
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 6, 16, 18, this.getButtonLocation("home"), (element, mouseX, mouseY) -> {
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.GO_HOME, (Entity)((GuiRobitMain)element.gui()).robit));
            Minecraft.getInstance().setScreen(null);
            return true;
        })).setTooltip(MekanismLang.ROBIT_TELEPORT);
        this.renameButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 6, 35, 18, this.getButtonLocation("rename"), (element, mouseX, mouseY) -> {
            GuiRobitMain gui = (GuiRobitMain)element.gui();
            gui.openWindow(new GuiRobitRename(gui, 27, 16, gui.robit), () -> this.renameButton);
            return true;
        })).setTooltip(MekanismLang.ROBIT_RENAME);
        this.skinButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 6, 54, 18, this.getButtonLocation("skin"), (element, mouseX, mouseY) -> {
            GuiRobitMain gui = (GuiRobitMain)element.gui();
            gui.openWindow(new GuiRobitSkinSelect(gui, 4, -12, gui.robit), () -> this.skinButton);
            return true;
        })).setTooltip(MekanismLang.ROBIT_SKIN_SELECT);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 152, 35, 18, this.getButtonLocation("drop"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.PICKUP_DROPS, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(MekanismLang.ROBIT_TOGGLE_PICKUP);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 152, 54, 18, this.getButtonLocation("follow"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.FOLLOW, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(MekanismLang.ROBIT_TOGGLE_FOLLOW);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, this.imageWidth + 3, 10, 18, this.getButtonLocation("main"), (element, mouseX, mouseY) -> true)).setTooltip(ROBIT);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, this.imageWidth + 3, 30, 18, this.getButtonLocation("crafting"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEntityButtonPress(PacketEntityButtonPress.ClickedEntityButton.ROBIT_CRAFTING, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(ROBIT_CRAFTING);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, this.imageWidth + 3, 50, 18, this.getButtonLocation("inventory"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEntityButtonPress(PacketEntityButtonPress.ClickedEntityButton.ROBIT_INVENTORY, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(ROBIT_INVENTORY);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, this.imageWidth + 3, 70, 18, this.getButtonLocation("smelting"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEntityButtonPress(PacketEntityButtonPress.ClickedEntityButton.ROBIT_SMELTING, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(ROBIT_SMELTING);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, this.imageWidth + 3, 90, 18, this.getButtonLocation("repair"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEntityButtonPress(PacketEntityButtonPress.ClickedEntityButton.ROBIT_REPAIR, (Entity)((GuiRobitMain)element.gui()).robit)))).setTooltip(ROBIT_REPAIR);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

