/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.List;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiSetEnergy;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater, MekanismTileContainer<TileEntityResistiveHeater>> {
    private GuiTextField energyUsageField;

    public GuiResistiveHeater(MekanismTileContainer<TileEntityResistiveHeater> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.inventoryLabelY += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 48, 23, 80, 42, () -> List.of(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.RESISTIVE_HEATER_USAGE.translate(EnergyDisplay.of(((TileEntityResistiveHeater)this.tile).getEnergyContainer().getEnergyPerTick())))).clearFormat());
        ((GuiBar)this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityResistiveHeater)this.tile).getEnergyContainer(), 164, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MachineEnergyContainer<TileEntityResistiveHeater> energyContainer = ((TileEntityResistiveHeater)this.tile).getEnergyContainer();
            return energyContainer.isEmpty() && energyContainer.getEnergyPerTick() > 0L;
        })).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY_REDUCED_RATE, () -> {
            MachineEnergyContainer<TileEntityResistiveHeater> energyContainer = ((TileEntityResistiveHeater)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick() > energyContainer.getEnergy();
        });
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityResistiveHeater)this.tile).getEnergyContainer(), ((TileEntityResistiveHeater)this.tile)::getEnergyUsed));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component temp = MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
            Component transfer = MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getLastTransferLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            Component environment = MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return List.of(MekanismLang.TEMPERATURE.translate(temp), MekanismLang.TRANSFERRED_RATE.translate(transfer), MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
        this.energyUsageField = this.addRenderableWidget(new GuiTextField(this, 50, 51, 76, 12));
        this.energyUsageField.setMaxLength(7);
        this.energyUsageField.setInputValidator(InputValidator.DIGIT).configureDigitalInput(this::setEnergyUsage);
        this.setInitialFocus((GuiEventListener)this.energyUsageField);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.ENERGY_USAGE, ((TileEntityResistiveHeater)this.tile).getBlockPos(), MekanismUtils.convertToJoules(Math.max(0L, Long.parseLong(this.energyUsageField.getText())))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.energyUsageField.setText("");
        }
    }

    @Override
    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget(new GuiWarningTab(this, warningTracker, false));
    }
}

