/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab.window;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.window.GuiWindowCreatorTab;
import mekanism.client.gui.element.window.GuiCraftingWindow;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class GuiCraftingWindowTab
extends GuiWindowCreatorTab<Void, GuiCraftingWindowTab> {
    private static final List<SelectedWindowData> VALID_WINDOWS = (List)Util.make(() -> {
        ArrayList<SelectedWindowData> valid = new ArrayList<SelectedWindowData>(3);
        for (byte i = 0; i < 3; i = (byte)(i + 1)) {
            valid.add(new SelectedWindowData(SelectedWindowData.WindowType.CRAFTING, i));
        }
        return List.copyOf(valid);
    });
    private static final Byte2ObjectMap<Tooltip> tooltips = new Byte2ObjectArrayMap(3);
    private final boolean[] openWindows = new boolean[3];
    private final QIOItemViewerContainer container;
    private byte currentWindows;

    public GuiCraftingWindowTab(IGuiWrapper gui, Supplier<GuiCraftingWindowTab> elementSupplier, QIOItemViewerContainer container) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "crafting.png"), gui, null, -26, 34, 26, 18, true, elementSupplier);
        this.container = container;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip((Tooltip)tooltips.computeIfAbsent(this.currentWindows, c -> TooltipUtils.create((Component)MekanismLang.CRAFTING_TAB.translate(c, (byte)3))));
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, SpecialColors.TAB_CRAFTING_WINDOW.get());
    }

    @Override
    protected Consumer<GuiWindow> getCloseListener() {
        return window -> {
            GuiCraftingWindowTab tab = (GuiCraftingWindowTab)this.getElementSupplier().get();
            if (window instanceof GuiCraftingWindow) {
                GuiCraftingWindow craftingWindow = (GuiCraftingWindow)window;
                tab.openWindows[craftingWindow.getIndex()] = false;
            }
            tab.currentWindows = (byte)(tab.currentWindows - 1);
            if (tab.currentWindows < 3) {
                tab.active = true;
            }
        };
    }

    @Override
    protected Consumer<GuiWindow> getReAttachListener() {
        return super.getReAttachListener().andThen(window -> {
            if (window instanceof GuiCraftingWindow) {
                GuiCraftingWindow craftingWindow = (GuiCraftingWindow)window;
                GuiCraftingWindowTab tab = (GuiCraftingWindowTab)this.getElementSupplier().get();
                tab.openWindows[craftingWindow.getIndex()] = true;
            }
        });
    }

    @Override
    protected void disableTab() {
        this.currentWindows = (byte)(this.currentWindows + 1);
        if (this.currentWindows >= 3) {
            super.disableTab();
        }
    }

    @Override
    protected SelectedWindowData getNextWindowData() {
        byte index = 0;
        for (int i = 0; i < this.openWindows.length; ++i) {
            if (this.openWindows[i]) continue;
            index = (byte)i;
            break;
        }
        return new SelectedWindowData(SelectedWindowData.WindowType.CRAFTING, index);
    }

    @Override
    protected List<SelectedWindowData> getValidWindows() {
        return VALID_WINDOWS;
    }

    @Override
    protected GuiWindow createWindow(SelectedWindowData windowData) {
        this.openWindows[windowData.extraData] = true;
        return new GuiCraftingWindow(this.gui(), (this.getGuiWidth() - 124) / 2, 15, this.container, windowData);
    }
}

