/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.EnumMap;
import java.util.Map;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiAmplifierTab
extends GuiInsetElement<TileEntityLaserAmplifier> {
    private static final ResourceLocation OFF = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "amplifier_off.png");
    private static final ResourceLocation ENTITY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "amplifier_entity.png");
    private static final ResourceLocation CONTENTS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "amplifier_contents.png");
    private final Map<TileEntityLaserAmplifier.RedstoneOutput, Tooltip> tooltips = new EnumMap<TileEntityLaserAmplifier.RedstoneOutput, Tooltip>(TileEntityLaserAmplifier.RedstoneOutput.class);

    public GuiAmplifierTab(IGuiWrapper gui, TileEntityLaserAmplifier tile) {
        super(OFF, gui, tile, gui.getXSize(), 109, 26, 18, false);
    }

    @Override
    protected ResourceLocation getOverlay() {
        return switch (((TileEntityLaserAmplifier)this.dataSource).getOutputMode()) {
            case TileEntityLaserAmplifier.RedstoneOutput.ENTITY_DETECTION -> ENTITY;
            case TileEntityLaserAmplifier.RedstoneOutput.ENERGY_CONTENTS -> CONTENTS;
            default -> super.getOverlay();
        };
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip(this.tooltips.computeIfAbsent(((TileEntityLaserAmplifier)this.dataSource).getOutputMode(), mode -> TooltipUtils.create((Component)MekanismLang.REDSTONE_OUTPUT.translate(mode))));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        PacketUtils.sendToServer(new PacketGuiInteract(button == 0 ? PacketGuiInteract.GuiInteraction.NEXT_MODE : PacketGuiInteract.GuiInteraction.PREVIOUS_MODE, (BlockEntity)this.dataSource));
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, SpecialColors.TAB_LASER_AMPLIFIER);
    }
}

