/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.function.DoubleConsumer;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiSlider
extends GuiElement {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "smooth_slider.png");
    private final DoubleConsumer callback;
    private double value;

    public GuiSlider(IGuiWrapper gui, int x, int y, int width, DoubleConsumer callback) {
        super(gui, x, y, width, 12);
        this.callback = callback;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void renderBackgroundOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderBackgroundOverlay(guiGraphics, mouseX, mouseY);
        GuiUtils.fill(guiGraphics, this.relativeX + 2, this.relativeY + 3, this.width - 4, 6, -11184811);
        int posX = (int)(this.value * (double)(this.width - 6));
        guiGraphics.blit(SLIDER, this.relativeX + posX, this.relativeY, 0.0f, 0.0f, 7, 12, 12, 12);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        this.set(mouseX, mouseY);
        this.setDragging(true);
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
        if (this.isDragging()) {
            this.set(mouseX, mouseY);
        }
    }

    @Override
    public boolean keyPressed(int key, int i, int j) {
        double shift;
        if (super.keyPressed(key, i, j)) {
            return true;
        }
        if (this.isPreviousButton(key) && this.value > 0.0) {
            shift = -0.01;
        } else if (this.isNextButton(key) && this.value < 1.0) {
            shift = 0.01;
        } else {
            return false;
        }
        this.value = Mth.clamp((double)(this.value + shift), (double)0.0, (double)1.0);
        this.callback.accept(this.value);
        return true;
    }

    private void set(double mouseX, double mouseY) {
        double oldValue = this.value;
        this.value = Mth.clamp((double)((mouseX - (double)this.getX() - 2.0) / (double)(this.width - 6)), (double)0.0, (double)1.0);
        if (!Mth.equal((double)this.value, (double)oldValue)) {
            this.callback.accept(this.value);
        }
    }

    private boolean isPreviousButton(int key) {
        return key == 265 || key == 263;
    }

    private boolean isNextButton(int key) {
        return key == 264 || key == 262;
    }
}

