/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PressurizedReactionCachedRecipe
extends CachedRecipe<PressurizedReactionRecipe> {
    private final IOutputHandler<@NotNull PressurizedReactionRecipe.PressurizedReactionRecipeOutput> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    private ItemStack recipeItem = ItemStack.EMPTY;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private ChemicalStack recipeChemical = ChemicalStack.EMPTY;
    @Nullable
    private PressurizedReactionRecipe.PressurizedReactionRecipeOutput output;

    public PressurizedReactionCachedRecipe(PressurizedReactionRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, IInputHandler<@NotNull FluidStack> fluidInputHandler, IInputHandler<@NotNull ChemicalStack> chemicalInputHandler, IOutputHandler<@NotNull PressurizedReactionRecipe.PressurizedReactionRecipeOutput> outputHandler) {
        super(recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = this.itemInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputSolid());
            if (this.recipeItem.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeFluid = this.fluidInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputFluid());
                if (this.recipeFluid.isEmpty()) {
                    tracker.mismatchedRecipe();
                } else {
                    this.recipeChemical = this.chemicalInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputChemical());
                    if (this.recipeChemical.isEmpty()) {
                        tracker.mismatchedRecipe();
                    } else {
                        this.itemInputHandler.calculateOperationsCanSupport(tracker, this.recipeItem);
                        if (tracker.shouldContinueChecking()) {
                            this.fluidInputHandler.calculateOperationsCanSupport(tracker, this.recipeFluid);
                            if (tracker.shouldContinueChecking()) {
                                this.chemicalInputHandler.calculateOperationsCanSupport(tracker, this.recipeChemical);
                                if (tracker.shouldContinueChecking()) {
                                    this.output = ((PressurizedReactionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeFluid, this.recipeChemical);
                                    this.outputHandler.calculateOperationsCanSupport(tracker, this.output);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isInputValid() {
        ItemStack item = this.itemInputHandler.getInput();
        if (item.isEmpty()) {
            return false;
        }
        ChemicalStack chemical = this.chemicalInputHandler.getInput();
        if (chemical.isEmpty()) {
            return false;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        return !fluid.isEmpty() && ((PressurizedReactionRecipe)this.recipe).test(item, fluid, chemical);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (!(this.output == null || this.recipeItem.isEmpty() || this.recipeFluid.isEmpty() || this.recipeChemical.isEmpty())) {
            this.itemInputHandler.use(this.recipeItem, operations);
            this.fluidInputHandler.use(this.recipeFluid, operations);
            this.chemicalInputHandler.use(this.recipeChemical, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

