/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.container.InContainerGetterLong;
import mekanism.api.container.LongToLongContainerInteraction;
import mekanism.api.energy.IEnergyContainer;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class LongTransferUtils {
    private LongTransferUtils() {
    }

    public static long insert(long stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, InContainerGetterLong inContainerGetter, LongToLongContainerInteraction insert) {
        if (stack <= 0L) {
            return 0L;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return stack;
        }
        if (containers == 1) {
            return insert.interact(0, stack, side, action);
        }
        long toInsert = stack;
        IntArrayList emptyContainers = new IntArrayList();
        for (int container = 0; container < containers; ++container) {
            long inContainer = inContainerGetter.getStored(container, side);
            if (inContainer == 0L) {
                emptyContainers.add(container);
                continue;
            }
            long remainder = insert.interact(container, toInsert, side, action);
            if (remainder <= 0L) {
                return 0L;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyContainers.iterator();
        while (intListIterator.hasNext()) {
            int container = (Integer)intListIterator.next();
            long remainder = insert.interact(container, toInsert, side, action);
            if (remainder <= 0L) {
                return 0L;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static long insert(long stack, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (stack <= 0L) {
            return 0L;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        return LongTransferUtils.insert(stack, action, automationType, energyContainers.size(), energyContainers);
    }

    public static long insert(long stack, Action action, AutomationType automationType, int containerCount, List<IEnergyContainer> energyContainers) {
        if (stack <= 0L) {
            return 0L;
        }
        if (containerCount == 0) {
            return stack;
        }
        if (containerCount == 1) {
            return energyContainers.get(0).insert(stack, action, automationType);
        }
        long toInsert = stack;
        ArrayList<IEnergyContainer> emptyContainers = new ArrayList<IEnergyContainer>();
        for (IEnergyContainer energyContainer : energyContainers) {
            long inContainer = energyContainer.getEnergy();
            if (inContainer == 0L) {
                emptyContainers.add(energyContainer);
                continue;
            }
            long remainder = energyContainer.insert(toInsert, action, automationType);
            if (remainder <= 0L) {
                return 0L;
            }
            toInsert = remainder;
        }
        for (IEnergyContainer container : emptyContainers) {
            long remainder = container.insert(toInsert, action, automationType);
            if (remainder <= 0L) {
                return 0L;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static long extract(long amount, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, LongToLongContainerInteraction extract) {
        if (amount <= 0L) {
            return 0L;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return 0L;
        }
        if (containers == 1) {
            return extract.interact(0, amount, side, action);
        }
        long extracted = 0L;
        long toExtract = amount;
        for (int container = 0; container < containers; ++container) {
            long drained = extract.interact(container, toExtract, side, action);
            if (drained <= 0L) continue;
            extracted = extracted == 0L ? drained : (extracted += drained);
            if ((toExtract -= drained) == 0L) break;
        }
        return extracted;
    }

    public static long extract(long amount, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (amount == 0L) {
            return 0L;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        return LongTransferUtils.extract(amount, action, automationType, energyContainers.size(), energyContainers);
    }

    public static long extract(long amount, Action action, AutomationType automationType, int containerCount, List<IEnergyContainer> energyContainers) {
        if (amount <= 0L || containerCount == 0) {
            return 0L;
        }
        if (containerCount == 1) {
            return energyContainers.get(0).extract(amount, action, automationType);
        }
        long extracted = 0L;
        long toExtract = amount;
        for (IEnergyContainer energyContainer : energyContainers) {
            long drained = energyContainer.extract(toExtract, action, automationType);
            if (drained <= 0L) continue;
            extracted = extracted == 0L ? drained : (extracted += drained);
            if ((toExtract -= drained) != 0L) continue;
            break;
        }
        return extracted;
    }
}

